% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DailyExtractAll.R
\name{DailyExtractAll}
\alias{DailyExtractAll}
\title{Extract daily time series}
\usage{
DailyExtractAll(cmip5dir, stndir, stnfile, qmapdir, SimAll, ModelNames,
  RcpNames, VarNames, OWrite)
}
\arguments{
\item{cmip5dir}{directory name contating daily CMIP5 data as NetCDF format}

\item{stndir}{directory name contating station information file}

\item{stnfile}{file name for station information}

\item{qmapdir}{directory name for storing extracted daily time series output}

\item{SimAll}{logical. TRUE then process goes over all the senarios available}

\item{ModelNames}{string vector contains climate change scenario models to be used}

\item{RcpNames}{Rcp names to be uses such as rcp45, rcp85}

\item{VarNames}{variable to be used such as prcp(precipitation), tmax/tmin, solor radiation, wind etc}

\item{OWrite}{Flag for overwriting output files (T: Overwrite, F: Skip)}
}
\description{
Extract daily time series for every combination of varialbes, GCM models, and RCP scenarios as text format
}
\examples{
\dontrun{
rSQMSampleProject() 
## Step 1. Set working environment
EnvList <- SetWorkingEnvironment(envfile = "rSQM.yaml")
## Step 2. Load climate scenario data
LoadCmip5DataFromAdss(dbdir = EnvList$dbdir, NtlCode = EnvList$NtlCode)
## Step 3. Extract daily time series
DailyExtractAll(
cmip5dir = EnvList$cmip5dir,
stndir = EnvList$stndir,
stnfile = EnvList$stnfile,
qmapdir = EnvList$qmapdir,
SimAll = EnvList$SimAll,
ModelNames = EnvList$ModelNames,
RcpNames = EnvList$RcpNames,
VarNames = EnvList$VarNames,
OWrite = EnvList$OWrite)
}
}
