% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get.sparsity.graph.rspde}
\alias{get.sparsity.graph.rspde}
\title{Sparsity graph for rSPDE models}
\usage{
get.sparsity.graph.rspde(
  mesh = NULL,
  fem_mesh_matrices = NULL,
  nu,
  force_non_integer = FALSE,
  rspde_order = 2,
  sharp = TRUE,
  dim = NULL
)
}
\arguments{
\item{mesh}{An INLA mesh, optional}

\item{fem_mesh_matrices}{A list containing the FEM-related matrices. The list should contain elements C, G, G_2, G_3, etc. Optional,
should be provided if mesh is not provided.}

\item{nu}{The smoothness parameter}

\item{force_non_integer}{Should nu be treated as non_integer?}

\item{rspde_order}{The order of the covariance-based rational SPDE approach.}

\item{sharp}{The graph should have the correct sparsity (costs more to perform
a sparsity analysis) or an upper bound for the sparsity?}

\item{dim}{The dimension, optional. Should be provided if mesh is not provided.}
}
\value{
The sparsity graph for rSPDE models to be used in R-INLA interface.
}
\description{
Creates the sparsity graph for rSPDE models
}
