% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSARP.r
\name{searchme}
\alias{searchme}
\title{\code{searchme} - Creates or modifies a Search Plan.}
\usage{
searchme(FtT = 3, filout = "SearchOut.csv", AreaUnits = "Hectares",
  graphs = 1, directory = "Searches", STitle = "")
}
\arguments{
\item{FtT}{- Fast to Thorough parameter - sets the relative hastiness of the search 1 = very fast, 5 = very thorough.  This is a parametric form of the team spacing.}

\item{filout}{- name of the output csv file to store in the workding directory. Defaults to "SearchOut.csv". This output files contains the input and output variables for each sector that comprises the search plan.}

\item{AreaUnits}{- a variable that toggles between Acres and Hectares area units. Defaults to "Hectares" for sectors. All area units are consistent with this selection within the program.}

\item{graphs}{- variable that toggles the creation and storage of graphs for each sector which describe the selected strategy for searching each sector. This parameter has the biggest impact on run time.  Defaults to graphs=1 (graphs will be produced and program will be at it's slowest).  Set to graphs = 2 to turn off sector graphs. Set to 3 to turn off all output in file form but still report to the console.}

\item{directory}{- name of the directory used to store output data from running this function. Defaults to the R working directory. The function will create a new subdirectory if the default value is changed.  Used to segregate output from different runs of the model.}

\item{STitle}{- string representing the name of the search for use as a title on the graphic output}
}
\value{
df - data frame that includes the input table with all unknown variables defined
}
\description{
The \code{searchme()} function takes the input csv file SearchInput.csv and returns the SearchOut.csv file which defines a search plan.
}
\details{
The \code{searchme()} function takes inputs including Sector,Area, AreaCovereage, Terrain, WX, TOD, THours,TSearchers,TSpacing, AMDR, Rank, and POScum in the form of a CSV file (SearchInput.csv) and returns values to the console and files to the working directory that form the basis of a search plan. At the console, a dataframe with new columns containing estimates for the man hours required, ideal team size, time to clear the sector, POS, POD, cumulative POS, and estimates to range these values between NASAR worst case estimates and Rule of Thumb estimates is returned. Then the function returns a summary of descriptive stats summarizing the plan followed by another display of the dataframe sorted alphabetically by name. The function stores the dataframe in the default SearchOut.csv file, along with a number of graphics displaying the model details by sector. After all sector stats and charts are generated, the fuction calls the \code{searchstatus()} function to create summary graphs for the search plan. See the documentation for \code{searchstatus()} for further information on those features.
The \code{searchme()} function is designed to predict optimal values for all key input variables where it finds the value -1.  In other cases, the program accepts the given value and assusmes the planner knows best, but graphs these values to allow planners to easily compare them to an Urban and a NASAR model.
}
\examples{
\dontrun{searchme(FtT=1.5, graphs=2, AreaUnits = "Acres", STitle="Example Loose Grid Search")}
\dontrun{searchme(FtT=4, graphs=3, STitle = "Example Tight Grid Search")}
}
\author{
John F. Hutcheson
}

