% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snd.R
\name{snd.write}
\alias{snd.write}
\title{snd.write}
\usage{
snd.write(snd, fileNameSound)
}
\arguments{
\item{snd}{Sound object (with \code{$sig}, \code{$nBits} and \code{$fs} members)}

\item{fileNameSound}{file name to be created}
}
\description{
Saves Sound object to a file.
snd is a list with \code{$sig} and \code{$fs} members at least. If \code{$nBits} is not present, default value of 16 bits is used. Vector \code{$t} is ignored. If the sound signal is 2-channel (stereo),
\code{$sig} must be a two-column matrix (1st column corresponds to the left channel, 2nd column to the right channel).
If the sound is 1-channel (mono), \code{$sig} can be either a numeric vector or a one-column matrix.
optional \code{$t}, \code{$nChannels}, \code{$nSamples}, \code{$duration} vectors are ignored.
}
\examples{
\dontrun{
snd <- snd.sample()
snd.plot(snd)
snd.write(snd, "temp1.wav")

signal <- 0.8*sin(seq(0, 2*pi*440, length.out = 8000))
snd.write(list(sig = signal, fs = 8000, nBits = 16), "temp2.wav")

left  <- 0.3*sin(seq(0, 2*pi*440, length.out = 4000))
rigth <- 0.5*sin(seq(0, 2*pi*220, length.out = 4000))
snd.write(list(sig = matrix(c(left, right), ncol = 2), fs = 8000, nBits = 16), "temp3.wav")
}
}
\seealso{
\code{\link{snd.read}}
}
