% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeqMotifOperator.R
\name{SeqMotifOperator}
\alias{SeqMotifOperator}
\title{Create a Sequence Motif Operator for Searches}
\usage{
SeqMotifOperator(pattern, sequence_type, pattern_type)
}
\arguments{
\item{pattern}{A string representing the motif pattern to search for.}

\item{sequence_type}{A string indicating the type of sequence ('DNA', 'RNA', or 'PROTEIN').}

\item{pattern_type}{A string indicating the type of pattern ('SIMPLE', 'PROSITE', or 'REGEX').}
}
\value{
An object of class 'SeqMotifOperator' representing the sequence motif operator.
}
\description{
Constructs a SeqMotifOperator object for use in sequence motif searches within the RCSB PDB.
This operator allows specifying a pattern, sequence type, and pattern type.
}
\examples{
seq_motif_operator <- SeqMotifOperator(pattern = "A[TU]G",
                                       sequence_type = "DNA",
                                       pattern_type = "REGEX")
seq_motif_operator
}
