% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_generics.R, R/ODESolver.R,
%   R/AbstractODESolver.R, R/DormandPrince45.R, R/Euler.R
\docType{methods}
\name{setStepSize}
\alias{setStepSize}
\alias{setStepSize,ODESolver-method}
\alias{setStepSize,AbstractODESolver-method}
\alias{setStepSize,DormandPrince45-method}
\alias{setStepSize,Euler-method}
\alias{getStepSize,Euler-method}
\title{setStepSize uses either of two step parameters: stepSize and dt
`stepSize`` works for most of the applications
`dt`` is used in Pendulum}
\usage{
setStepSize(object, ...)

\S4method{setStepSize}{ODESolver}(object, stepSize, ...)

\S4method{setStepSize}{AbstractODESolver}(object, stepSize, ...)

\S4method{setStepSize}{DormandPrince45}(object, stepSize, ...)

\S4method{setStepSize}{Euler}(object, stepSize, ...)

\S4method{getStepSize}{Euler}(object, ...)
}
\arguments{
\item{object}{a class object}

\item{...}{additional parameters}

\item{stepSize}{size of the step}
}
\description{
setStepSize uses either of two step parameters: stepSize and dt
`stepSize`` works for most of the applications
`dt`` is used in Pendulum

Set the size of the step
}
\examples{
# ++++++++++++++++++++++++++++++++++++++++++++++++++application:  SpringRK4App.R
# Simulation of a spring considering no friction

importFromExamples("SpringRK4.R")


# run application
SpringRK4App <- function(verbose = FALSE) {
    theta    <- 0
    thetaDot <- -0.2
    tmax     <- 22; dt <- 0.1
    ode <- new("ODE")
    spring <- SpringRK4()
    spring@state[3] <- 0      # set time to zero, t = 0
    spring <- setState(spring, theta, thetaDot)
    spring <- setStepSize(spring, dt = dt) # using stepSize in RK4
    spring@odeSolver <- setStepSize(spring@odeSolver, dt) # set new step size
    rowvec <- vector("list")
    i <- 1
    while (spring@state[3] <= tmax)    {
        rowvec[[i]] <- list(t  = spring@state[3],      # angle
                            y1 = spring@state[1],      # derivative of the angle
                            y2 = spring@state[2])      # time
        i <- i + 1
        spring <- step(spring)
    }
    DT <- data.table::rbindlist(rowvec)
    return(DT)
}

# show solution
solution <- SpringRK4App()
plot(solution)
# ++++++++++++++++++++++++++++++++++++++++++++++++  example: ComparisonRK45App.R
# Compares the solution by the RK45 ODE solver versus the analytical solution
# Example file: ComparisonRK45App.R
# ODE Solver:   Runge-Kutta 45
# Class:        RK45

importFromExamples("ODETest.R")

 ComparisonRK45App <- function(verbose = FALSE) {
     ode <- new("ODETest")                     # create an `ODETest` object
     ode_solver <- RK45(ode)                   # select the ODE solver
     ode_solver <- setStepSize(ode_solver, 1)      # set the step
     ode_solver <- setTolerance(ode_solver, 1e-8)  # set the tolerance
     time <-  0
     rowVector <- vector("list")
     i <- 1
     while (time < 50) {
         rowVector[[i]] <- list(t  = ode_solver@ode@state[2],
                                s1 = getState(ode_solver@ode)[1],
                                s2 = getState(ode_solver@ode)[2],
                                xs = getExactSolution(ode_solver@ode, time),
                                rc = getRateCounts(ode),
                                time = time)
         ode_solver <- step(ode_solver)       # advance one step
         stepSize <-  ode_solver@stepSize     # update the step size
         time <- time + stepSize
         state <- getState(ode_solver@ode)    # get the `state` vector
         i <- i + 1
     }
     return(data.table::rbindlist(rowVector))    # a data table with the results
 }
# show solution
solution <- ComparisonRK45App()                          # run the example
plot(solution)
}
