% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.PCA.r
\name{MVP.PCA}
\alias{MVP.PCA}
\title{Principal Component Analysis}
\usage{
MVP.PCA(
  M = NULL,
  K = NULL,
  priority = c("speed", "memory"),
  pcs.keep = 5,
  cpu = 1,
  verbose = TRUE
)
}
\arguments{
\item{M}{Genotype in numeric format, pure 0, 1, 2 matrix; m * n, m is marker size, n is population size}

\item{K}{kinship matrix}

\item{priority}{speed or memory}

\item{pcs.keep}{maximum number of PCs for output}

\item{cpu}{the number of cpu}

\item{verbose}{whether to print detail.}
}
\value{
Output: PCs - a n * npc matrix of top number of PCs, n is population size and npc is @param pcs.keep
}
\description{
Build date: Dec 14, 2016
Last update: Oct 29, 2018
}
\examples{
\donttest{
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

pca <- MVP.PCA(M=genotype, cpu=1)
str(pca)
}

}
\author{
Xiaolei Liu, Lilin Yin and Haohao Zhang
}
