% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_class.R
\name{setGroup}
\alias{setGroup}
\title{Sets the group of MEA objects}
\usage{
setGroup(mea, group)
}
\arguments{
\item{mea}{a single or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{group}{a text string specifying a group name}
}
\value{
an object of the same type of \code{'mea'}, with the group attributes set to \code{group}.
}
\description{
Sets the group of MEA objects
}
\examples{
## read a sample
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep = "_",  skip = 1)
mea_normal <- setGroup(mea_normal, "normal")
}
