% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMea_filter.R
\name{MEAscale}
\alias{MEAscale}
\title{Scaling (and centering) of motion energy time-series}
\usage{
MEAscale(mea, scale = "sd", ..., center = F, removeNA = T)
}
\arguments{
\item{mea}{an object of class \code{MEA} or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{scale}{either a numeric value or a function to be applied to each motion
energy time-series to calculate a scaling factor. Default is standard deviation.}

\item{...}{further arguments passed to \code{scale} if it is a function.}

\item{center}{either a logical value or a numeric vector of length 2 specifying separate centering values for s1 and s2.}

\item{removeNA}{logical. If \code{scale} is a function, defines whether NAs be removed prior to calculating the scaling factor.}
}
\value{
returns the same \code{MEA} or \code{MEAlist} object, with all motion energy data rescaled
}
\description{
Scaling (and centering) of motion energy time-series
}
\details{
If \code{scale} is a function, it is found by a call to  \code{\link[base]{match.fun}} and typically is either a function
or a symbol (e.g., a backquoted name) or a character string specifying a function
to be searched for from the environment of the call to apply. Note that the chosen function must return a single numeric value.

\code{center} is directly passed to \code{\link[base]{scale}}. If \code{center} is \code{TRUE} then centering
is done by subtracting the means (omitting NAs) from the motion energy time-series. If \code{center} is a numeric vector,
the first value will be subtracted from s1 and the second from s2.
Note: the s1 and s2 signals are scaled independently.
}
\examples{
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_raw <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)

## rescale by factor 0.7
mea_scaled = MEAscale(mea_raw, scale = 0.7)

## rescale with standard deviation
mea_scaled = MEAscale(mea_raw, scale = "sd", removeNA = TRUE)

## assign groups names
mea_raw <- setGroup(mea_raw, "raw")
mea_scaled <- setGroup(mea_scaled, "scaled")

## Compute ccf
mea_raw <- MEAccf(mea_raw, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = FALSE)
mea_scaled <- MEAccf(mea_scaled, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = FALSE)

## Compare the effect of scaling on ccf
MEAlagplot(mea_scaled, contrast = mea_raw)

}
