% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_graphics.R
\name{plot.MEA}
\alias{plot.MEA}
\title{Plots an object of class \code{MEA}}
\usage{
\method{plot}{MEA}(x, from = 1, to = nrow(mea$MEA), ccf = F,
  rescale = F, ...)
}
\arguments{
\item{x}{an object of class \code{MEA} (see function \code{\link{readMEA}}).}

\item{from}{integer. The first sample to be plotted. Defaults to the first sample of signal}

\item{to}{integer. The last sample to be plotted. Defaults to the whole length of the signal.}

\item{ccf}{either FALSE or a string representing the type of ccf to be overlayed.
One of "sync", "pace", "zero", "lead", "pace0", "lead0".}

\item{rescale}{logical. Should the motion energy time-series be rescaled?}

\item{...}{further arguments passed to \code{plot}}
}
\description{
Plots an object of class \code{MEA}
}
\details{
Note: if more of than 10s of trailing zeroes are found at the end of both s1 and s2 signals they are truncated.
}
\examples{
## read a single file
path_normal <- system.file("extdata/normal/200_01.txt", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist", skip=1,
                     idOrder = c("id","session"), idSep="_")
## Visual inspection of the data
plot(mea_normal[[1]], from = 1500, to = 3500)

}
