% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{readLAS}
\alias{readLAS}
\title{Reading LiDAR data}
\usage{
readLAS(LASfile, short=TRUE)
}
\arguments{
\item{LASfile}{A standard LAS data file (ASPRS)}

\item{short}{Logical, if TRUE it will return only a 5-column matrix with information on the returned point x, y, z locations, point intensity and the number of return within an individual discrete-return system laser pulse.}
}
\value{
Returns a matrix listing the information stored in the LAS file.
}
\description{
This function reads and returns values associated with the LAS file format. The LAS file is a public file format for the interchange of LiDAR 3-dimensional point cloud data (American Society of Photogrammetry and Remote Sensing - ASPRS)
}
\examples{

#=======================================================================#
# Importing LAS file:
#=======================================================================#
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Reading LAS file
rLAS<-readLAS(LASfile,short=TRUE)

# Summary of the LAS file
summary(rLAS)

#=======================================================================#
# LAS file visualization:
#=======================================================================#

# 01 Set a single color 

col<-"forestgreen"

# plot 2D
plot(rLAS[,1],rLAS[,2], col=col,xlab="UTM.Easting", ylab="UTM.Northing", main="Single color")

# plot 3D
library(rgl)
points3d(rLAS[,1:3], col=col, axes=FALSE,xlab="", ylab="", zlab="")
axes3d(c("x+", "y-", "z-"))                 # axes
grid3d(side=c('x+', 'y-', 'z'), col="gray") # grid
title3d(xlab = "UTM.Easting", ylab = "UTM.Northing",zlab = "Height(m)", col="red") # title
planes3d(0, 0, -1, 0.001, col="gray", alpha=0.7)   # terrain


# 02 Set a color by height 

# color ramp
myColorRamp <- function(colors, values) {
v <- (values - min(values))/diff(range(values))
x <- colorRamp(colors)(v)
rgb(x[,1], x[,2], x[,3], maxColorValue = 255)
}

# Color by height
col <- myColorRamp(c("blue","green","yellow","red"),rLAS[,3])

# plot 2D
plot(rLAS[,1], rLAS[,2], col=col, xlab="UTM.Easting", ylab="UTM.Northing", main="Color by height")

# plot 3D
points3d(rLAS[,1:3], col=col, axes=FALSE, xlab="", ylab="", zlab="")
axes3d(c("x+", "y-", "z-"))                     # axes
grid3d(side=c('x+', 'y-', 'z'), col="gray")     # grid
title3d(xlab = "UTM.Easting", ylab = "UTM.Northing",zlab = "Height(m)", col="red") # title
planes3d(0, 0, -1, 0.001, col="gray",alpha=0.7) # terrain

}
\author{
Michael Sumner and Carlos Alberto Silva.
}
