# rENA <img src="man/figures/logo.png" align="right" alt="" width="120" />

[![cran status](https://www.r-pkg.org/badges/version-ago/rENA)](https://cran.r-project.org/package=rENA) 
[![cran downloads](https://cranlogs.r-pkg.org/badges/grand-total/rENA)](https://cranlogs.r-pkg.org/badges/grand-total/rENA) 
[![pipeline status](https://gitlab.com/epistemic-analytics/qe-packages/rENA/badges/main/pipeline.svg)](https://gitlab.com/epistemic-analytics/qe-packages/rENA/-/commits/main)
[![coverage report](https://gitlab.com/epistemic-analytics/qe-packages/rENA/badges/main/coverage.svg)](https://gitlab.com/epistemic-analytics/qe-packages/rENA/-/commits/main)

## What is ENA

[Epistemic Network Analysis](https://www.epistemicnetwork.org/) (ENA) is a method for identifying and quantifying connections among elements in coded data and representing them in dynamic network models. A key feature of the ENA tool is that it enables researchers compare different networks, both visually and through summary statistics that reflect the weighted structure of connections. The interface also allows users to see the original data that contributed to each of the connections in the network representation. ENA can thus be used to address a wide range of qualitative and quantitative research questions.

Researchers have used ENA to analyze and visualize a wide range of phenomena, including: cognitive connections that students make while solving complex problems; interactions among different regions of the brain in fMRI data; social gaze coordination; integration of operative skills during surgical procedures; and many others.

---

## Installation

### From CRAN

[![cran status](https://www.r-pkg.org/badges/version-ago/rENA)](https://cran.r-project.org/package=rENA) 
[![cran downloads](https://cranlogs.r-pkg.org/badges/grand-total/rENA)](https://cranlogs.r-pkg.org/badges/grand-total/rENA) 

```
install.packages("rENA")
```

### Development Version

[![pipeline status](https://gitlab.com/epistemic-analytics/qe-packages/rENA/badges/main/pipeline.svg)](https://gitlab.com/epistemic-analytics/qe-packages/rENA/-/commits/main)
[![coverage report](https://gitlab.com/epistemic-analytics/qe-packages/rENA/badges/main/coverage.svg)](https://gitlab.com/epistemic-analytics/qe-packages/rENA/-/commits/main)

```
install.packages("rENA", repos = c("https://cran.qe-libs.org", "https://cran.rstudio.org"))
```

---
## Resources

To learn more about ENA, visit the [resources page](https://www.epistemicnetwork.org/resources/).
