% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tde_gp.R
\name{tde_gp}
\alias{tde_gp}
\title{Perform univariate forecasting using Gaussian processes}
\usage{
tde_gp(time_series, lib = c(1, NROW(time_series)), pred = lib, E = 1:10,
  tau = 1, tp = 1, phi = 0, v_e = 0, eta = 0, fit_params = TRUE,
  stats_only = TRUE, save_covariance_matrix = FALSE, silent = FALSE, ...)
}
\arguments{
\item{time_series}{either a vector to be used as the time series, or a 
data.frame or matrix with at least 2 columns (in which case the first column 
will be used as the time index, and the second column as the time series)}

\item{lib}{a 2-column matrix (or 2-element vector) where each row specifes the 
first and last *rows* of the time series to use for attractor reconstruction}

\item{pred}{(same format as lib), but specifying the sections of the time 
series to forecast.}

\item{E}{the embedding dimensions to use for time delay embedding}

\item{tau}{the lag to use for time delay embedding}

\item{tp}{the prediction horizon (how far ahead to forecast)}

\item{phi}{length-scale parameter. see 'Details'}

\item{v_e}{noise-variance parameter. see 'Details'}

\item{eta}{signal-variance parameter. see 'Details'}

\item{fit_params}{specify whether to use MLE to estimate params over the lib}

\item{stats_only}{specify whether to output just the forecast statistics or 
the raw predictions for each run}

\item{save_covariance_matrix}{specifies whether to include the full 
covariance matrix with the output (and forces the full output as if 
stats_only were set to FALSE)}

\item{silent}{prevents warning messages from being printed to the R console}

\item{...}{other parameters. see 'Details'}
}
\value{
If stats_only, then a data.frame with components for the parameters 
  and forecast statistics:
\tabular{ll}{
  E \tab embedding dimension\cr
  tp \tab prediction horizon\cr
  phi \tab length-scale parameter\cr
  v_e \tab noise-variance parameter\cr
  eta \tab signal-variance parameter\cr
  fit_params \tab whether params were fitted or not\cr
  num_pred \tab number of predictions\cr
  rho \tab correlation coefficient between observations and predictions\cr
  mae \tab mean absolute error\cr
  rmse \tab root mean square error\cr
  perc \tab percent correct sign\cr
  p_val \tab p-value that rho is significantly greater than 0 using Fisher's 
  z-transformation\cr
}
If stats_only is FALSE or save_covariance_matrix is TRUE, then there is an 
additional list-column variable:
\tabular{ll}{
  model_output \tab data.frame with columns for the time index, observations, 
    and mean-value for predictions\cr
}
If save_covariance_matrix is TRUE, then there is an additional list-column variable:
\tabular{ll}{
  covariance_matrix \tab covariance matrix for predictions\cr
}
}
\description{
\code{tde_gp} is used in the same vein as \code{simplex} or \code{s-map} to 
do time series forecasting using Gaussian processes. Here, the default 
parameters are set so that passing a time series as the only argument will 
run over E = 1:10 (embedding dimension) to created a lagged block, and 
passing in that block and all remaining arguments into \code{block_gp}.
}
\details{
See \code{block_gp} for implementation details of the Gaussian process 
regression.
}
\examples{
data("two_species_model")
ts <- two_species_model$x[1:200]
tde_gp(ts, lib = c(1, 100), pred = c(101, 200), E = 5)
}
