% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_table.R
\name{write_table}
\alias{write_table}
\title{Write table component to HDF5 file}
\usage{
write_table(
  df,
  handle,
  data_product,
  component,
  description,
  row_names,
  column_units
)
}
\arguments{
\item{df}{an \code{dataframe} containing the data}

\item{handle}{an object of class \code{fdp, R6} containing metadata required
by the Data Pipeline API}

\item{data_product}{a \code{string} specifying the name of the data product}

\item{component}{a \code{string} specifying a location within the hdf5 file,}

\item{description}{a \code{string} describing the data product component}

\item{row_names}{(optional) a \code{vector} of rownames}

\item{column_units}{(optional) a \code{vector} comprising column units}
}
\value{
Returns a handle index associated with the just written component,
which can be used to raise an issue if necessary
}
\description{
Function to populate hdf5 file with array type data.
}
\seealso{
Other write functions: 
\code{\link{write_array}()},
\code{\link{write_distribution}()},
\code{\link{write_estimate}()}
}
\concept{write functions}
