% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assign_max_street_time}
\alias{assign_max_street_time}
\title{Assign max street time from walk/bike distance and speed}
\usage{
assign_max_street_time(max_time, speed, max_trip_duration, mode)
}
\arguments{
\item{max_time}{A numeric of length 1. Maximum walking distance (in
meters) for the whole trip. Passed from routing functions.}

\item{speed}{A numeric of length 1. Average walk speed in km/h.
Defaults to 3.6 Km/h. Passed from routing functions.}

\item{max_trip_duration}{A numeric of length 1. Maximum trip duration in
seconds. Defaults to 120 minutes (2 hours). Passed from routing functions.}

\item{mode}{A string. Either \code{"bike"} or \code{"walk"}.}
}
\value{
An \code{integer} representing the maximum number of minutes walking.
}
\description{
Checks the time duration and speed inputs and converts them to distance.
}
\seealso{
Other assigning functions: 
\code{\link{assign_decay_function}()},
\code{\link{assign_departure}()},
\code{\link{assign_drop_geometry}()},
\code{\link{assign_max_trip_duration}()},
\code{\link{assign_mode}()},
\code{\link{assign_opportunities}()},
\code{\link{assign_points_input}()},
\code{\link{assign_shortest_path}()}
}
\concept{assigning functions}
\keyword{internal}
