% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_readctl.R
\name{SS_readctl}
\alias{SS_readctl}
\title{read control file from SS}
\usage{
SS_readctl(file, version = NULL, verbose = TRUE, echoall = FALSE,
  nseas = 4, N_areas = 1, Nages = 20, Ngenders = 1,
  Npopbins = NA, Nfleet = 2, Nsurveys = 2, N_tag_groups = NA,
  N_CPUE_obs = NA, use_datlist = FALSE, datlist = NULL,
  ptype = TRUE)
}
\arguments{
\item{file}{Filename either with full path or relative to working directory.}

\item{version}{SS version number. Currently only "3.24" or "3.30" are supported,
either as character or numeric values (noting that numeric 3.30  = 3.3).}

\item{verbose}{Should there be verbose output while running the file?
Default=TRUE.}

\item{echoall}{Debugging tool (not fully implemented) of echoing blocks of
data as it is being read.}

\item{nseas}{number of season in the model. This information is not
explicitly available in control file}

\item{N_areas}{number of spatial areas in the model. This information is also not
explicitly available in control file}

\item{Nages}{oldest age in the model. This information is also not
explicitly available in control file}

\item{Ngenders}{number of genders in the model. This information is also not
explicitly available in control file}

\item{Npopbins}{number of population bins in the model. This information is
also not explicitly available in control file and this information is only
required if length based
 maturity vector is directly supplied (Maturity option of 6), and not yet tested}

\item{Nfleet}{number of fisheries in the model. This information is also not
explicitly available in control file}

\item{Nsurveys}{number of survey fleets in the model. This information is also not
explicitly available in control file}

\item{N_tag_groups}{number of tag release groups in the model.
This information is also not explicitly available in control file.}

\item{N_CPUE_obs}{number of CPUE observations.}

\item{use_datlist}{LOGICAL if TRUE, use datlist to derive parameters which can not be
determined from control file}

\item{datlist}{list or character. if list : produced from SS_writedat
or character : file name of dat file.}

\item{ptype}{include a column in the output indicating parameter type?
(Can be useful, but causes problems for SS_writectl.) Only possible to use
for 3.24 control files.}
}
\description{
Read Stock Synthesis control file into list object in R. This function is a
wrapper which calls either SS_readctl_3.24 or SS_readctl_3.30 (not yet written).
This setup allows those functions to be cleaner (if somewhat redundant)
than a single function that attempts to do everything.
}
\seealso{
\code{\link{SS_readctl_3.24}}, \code{\link{SS_readdat}},
\code{\link{SS_readdat_3.24}}
}
\author{
Ian G. Taylor, Yukio Takeuchi, Neil L Klaer
}
