% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_rtf_text.R
\name{obj_rtf_text}
\alias{obj_rtf_text}
\title{Create an RTF Text Object}
\usage{
obj_rtf_text(
  text,
  text_font = 1,
  text_format = NULL,
  text_font_size = 9,
  text_color = NULL,
  text_background_color = NULL,
  text_justification = "l",
  text_indent_first = 0,
  text_indent_left = 0,
  text_indent_right = 0,
  text_space = 1,
  text_space_before = 15,
  text_space_after = 15,
  text_new_page = FALSE,
  text_hyphenation = TRUE,
  text_convert = TRUE
)
}
\arguments{
\item{text}{A character string.}

\item{text_font}{Text font type. Default is 1 for Times New Roman. To vary text font type
by column, use numeric vector with length of vector equal to number of
columns displayed e.g. c(1,2,3).All possible input can be found
in \code{r2rtf:::font_type()$type}.}

\item{text_format}{Text format type. Default is NULL for normal. Combination of format type
are permitted as input for e.g. "ub" for bold and underlined text. To vary
text format by column, use character vector with length of vector equal to
number of columns displayed e.g. c("i","u","ib"). All possible input
can be found in \code{r2rtf:::font_format()$type}.}

\item{text_font_size}{Text font size. Default is 9. To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{text_color}{Text color type. Default is NULL for black. To vary text color by column,
use character vector with length of vector equal to number of columns
displayed e.g. c("white","red","blue"). All possible input can be found
in \code{grDevices::colors()}.}

\item{text_background_color}{Text background color type. Default is NULL for white. To vary
text color by column, use character vector with length of vector
equal to number of columns displayed e.g. c("white","red","blue").
All possible input can be found in \code{grDevices::colors()}.}

\item{text_justification}{Justification type for text. Default is "c" for center justification.
To vary text justification by column, use character vector with
length of vector equal to number of columns displayed e.g. c("c","l","r").
All possible input can be found in \code{r2rtf:::justification()$type}.}

\item{text_indent_first}{A value of first indent.}

\item{text_indent_left}{A value of left indent.}

\item{text_indent_right}{A value of right indent.}

\item{text_space}{A value of text space.}

\item{text_space_before}{Line space before text in twips. Default is 15 for 0.0104 inch.}

\item{text_space_after}{Line space after text in twips. Default is 15 for 0.0104 inch.}

\item{text_new_page}{A logical value to control whether display text in new page. Default is FALSE.}

\item{text_hyphenation}{A logical value to control whether display text linked with hyphenation. Default is TRUE.}

\item{text_convert}{A logical value to convert special characters. Default is TRUE.}
}
\value{
the same text (data frame or text) with additional attributes
}
\description{
Create an RTF Text Object
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Input checks using \code{check_args()}, \code{match_arg()} and \code{stopifnot()}.
   \item Define text attributes based on the input.
   \item Return text with attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

