% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/hashmap.R, R/hashset.R
\name{delete}
\alias{delete}
\alias{delete.r2r_hashmap}
\alias{delete.r2r_hashset}
\title{Delete keys or key/value pairs from an hash table.}
\usage{
delete(x, key)

\method{delete}{r2r_hashmap}(x, key)

\method{delete}{r2r_hashset}(x, key)
}
\arguments{
\item{x}{an \code{hashset} or \code{hashmap}.}

\item{key}{an arbitrary R object. Key to be deleted from the hash table.}
}
\value{
\code{NULL}, invisibly.
}
\description{
These generics are used for deleting a single key or key/value
pair from an \code{hashset} or \code{hashmap}, respectively.
}
\examples{
s <- hashset(1, 2, 3)
delete(s, 3)
s[[3]]
}
\author{
Valerio Gherardi
}
