/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;

import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Interval;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator implements ExpressionTranslatorConstants {

        static
        public Expression translateExpression(String string){
                return translateExpression(string, true);
        }

        static
        public Expression translateExpression(String string, boolean compact){
                Expression expression;

                try {
                        ExpressionTranslator translator = new ExpressionTranslator(string);

                        expression = translator.translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException(string, pe);
                }

                if(compact){
                        ExpressionCompactor compactor = new ExpressionCompactor();

                        compactor.applyTo(expression);
                }

                return expression;
        }

        static
        public Interval translateInterval(String string){
                Interval interval;

                try {
                        ExpressionTranslator translator = new ExpressionTranslator(string);

                        interval = translator.translateIntervalInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException(string, pe);
                }

                return interval;
        }

        static
        private String translateLogicalOperator(Token operator){

                switch(operator.kind){
                        case AND:
                                return PMMLFunctions.AND;
                        case OR:
                                return PMMLFunctions.OR;
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case PLUS:
                        case MINUS:
                        case MULTIPLY:
                        case DIVIDE:
                                return operator.image;
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateRelationalOperator(Token operator){

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateFunction(String function){

                switch(function){
                        case "abs":
                                return PMMLFunctions.ABS;
                        case "ceiling":
                                return PMMLFunctions.CEIL;
                        case "exp":
                                return PMMLFunctions.EXP;
                        case "floor":
                                return PMMLFunctions.FLOOR;
                        case "log":
                                return PMMLFunctions.LN;
                        case "log10":
                                return PMMLFunctions.LOG10;
                        case "round":
                                return PMMLFunctions.ROUND;
                        case "sqrt":
                                return PMMLFunctions.SQRT;
                        default:
                                break;
                }

                switch(function){
                        case "is.na":
                                return PMMLFunctions.ISMISSING;
                        default:
                                throw new IllegalArgumentException(function);
                }
        }

        static
        private String translateValue(Token value){
                String image = value.image;

                switch(value.kind){
                        case FALSE:
                        case TRUE:
                                return image.toLowerCase();
                        case INF:
                                return "Infinity";
                        case NAN:
                                return "NaN";
                        case STRING:
                                return image.substring(1, image.length() - 1);
                        default:
                                return image;
                }
        }

        static
        private String translateTag(Token tag){
                String image = tag.image;

                switch(tag.kind){
                        case IDENTIFIER:
                                return image;
                        case STRING:
                                return image.substring(1, image.length() - 1);
                        default:
                                throw new IllegalArgumentException();
                }
        }

        static
        private Interval.Closure translateClosure(String leftBound, String rightBound){
                String closure = (leftBound + rightBound);

                switch(closure){
                        case "()":
                                return Interval.Closure.OPEN_OPEN;
                        case "(]":
                                return Interval.Closure.OPEN_CLOSED;
                        case "[)":
                                return Interval.Closure.CLOSED_OPEN;
                        case "[]":
                                return Interval.Closure.CLOSED_CLOSED;
                        default:
                                throw new IllegalArgumentException(closure);
                }
        }

        static
        private Double filterMargin(Double value){

                if(value.isNaN()){
                        throw new IllegalArgumentException();
                } // End if

                if(value.isInfinite()){
                        return null;
                }

                return value;
        }

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
}

/*
 * See https://stat.ethz.ch/R-manual/R-devel/library/base/html/Syntax.html
 */
  final public Expression Expression() throws ParseException {Expression expression;
    if (jj_2_1(2147483647)) {
      expression = IfExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case LPAREN:
      case NOT:
      case FALSE:
      case INF:
      case NAN:
      case TRUE:
      case INT:
      case FLOAT:
      case IDENTIFIER:
      case STRING:{
        expression = OrExpression();
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expression;
}

  final public Expression IfExpression() throws ParseException {Expression condition;
        Expression first;
        Expression second = null;
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    first = Expression();
    if (jj_2_2(2147483647)) {
      jj_consume_token(ELSE);
      second = Expression();
    } else {
      ;
    }
if(second != null){
                        return PMMLUtil.createApply(PMMLFunctions.IF, condition, first, second);
                }

                return PMMLUtil.createApply(PMMLFunctions.IF, condition, first);
}

  final public Expression OrExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = AndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      operator = jj_consume_token(OR);
      right = AndExpression();
left = PMMLUtil.createApply(translateLogicalOperator(operator), left, right);
    }
return left;
}

  final public Expression AndExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = NegationExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      operator = jj_consume_token(AND);
      right = NegationExpression();
left = PMMLUtil.createApply(translateLogicalOperator(operator), left, right);
    }
return left;
}

  final public Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    expression = RelationalExpression();
if(operator != null){
                        return PMMLUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
}

  final public Expression RelationalExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = AdditiveExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQUAL:
    case NOT_EQUAL:
    case LESS_THAN:
    case LESS_OR_EQUAL:
    case GREATER_THAN:
    case GREATER_OR_EQUAL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQUAL:{
        operator = jj_consume_token(EQUAL);
        break;
        }
      case NOT_EQUAL:{
        operator = jj_consume_token(NOT_EQUAL);
        break;
        }
      case LESS_THAN:{
        operator = jj_consume_token(LESS_THAN);
        break;
        }
      case LESS_OR_EQUAL:{
        operator = jj_consume_token(LESS_OR_EQUAL);
        break;
        }
      case GREATER_THAN:{
        operator = jj_consume_token(GREATER_THAN);
        break;
        }
      case GREATER_OR_EQUAL:{
        operator = jj_consume_token(GREATER_OR_EQUAL);
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = AdditiveExpression();
left = PMMLUtil.createApply(translateRelationalOperator(operator), left, right);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
return left;
}

  final public Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final public Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        sign = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        sign = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    expression = ExponentiationExpression();
if(sign != null && sign.kind == MINUS){
                        expression = PMMLUtil.toNegative(expression);
                }

                return expression;
}

  final public Expression ExponentiationExpression() throws ParseException {Expression left;
        Token operator = null;
        Expression right = null;
    left = PrimaryExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case POWER:
    case POWER_MULTIPLY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case POWER:{
        operator = jj_consume_token(POWER);
        break;
        }
      case POWER_MULTIPLY:{
        operator = jj_consume_token(POWER_MULTIPLY);
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(PMMLFunctions.POW, left, right);
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
return left;
}

  final public Expression PrimaryExpression() throws ParseException {Expression expression;
    if (jj_2_3(2147483647)) {
      expression = FunctionInvocationExpression();
    } else if (jj_2_4(2147483647)) {
      expression = FunctionInvocationExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENTIFIER:{
        expression = FieldInvocationExpression();
        break;
        }
      case LPAREN:{
        expression = ParenthesizedExpression();
        break;
        }
      case FALSE:
      case INF:
      case NAN:
      case TRUE:
      case INT:
      case FLOAT:
      case STRING:{
        expression = Constant();
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expression;
}

  final public Expression FunctionInvocationExpression() throws ParseException {Token namespace = null;
        Token function;
        Token begin;
        Token end;
        List<FunctionExpression.Argument> arguments;
    if (jj_2_5(2147483647)) {
      namespace = jj_consume_token(IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_COLON:{
        jj_consume_token(DOUBLE_COLON);
        break;
        }
      case TRIPLE_COLON:{
        jj_consume_token(TRIPLE_COLON);
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      function = jj_consume_token(IDENTIFIER);
      begin = jj_consume_token(LPAREN);
      arguments = ArgumentList();
      end = jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENTIFIER:{
        function = jj_consume_token(IDENTIFIER);
        begin = jj_consume_token(LPAREN);
        arguments = ArgumentList();
        end = jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if(arguments.size() > 0){
                        FunctionExpression.Argument firstArgument = arguments.get(0);
                        firstArgument.setBegin(begin);

                        FunctionExpression.Argument lastArgument = arguments.get(arguments.size() - 1);
                        lastArgument.setEnd(end);
                }

                try {
                        String pmmlFunction = translateFunction(function.image);

                        if(arguments.size() == 1){
                                FunctionExpression.Argument argument = arguments.get(0);

                                if(!argument.hasTag() && !(argument.getExpression() instanceof FunctionExpression)){
                                        return PMMLUtil.createApply(pmmlFunction, argument.getExpression());
                                }
                        }
                } catch(IllegalArgumentException iae){
                        // Ignored
                }

                FunctionExpression functionExpression;

                if(namespace != null){
                        functionExpression = new FunctionExpression(namespace.image, function.image, arguments);
                } else

                {
                        functionExpression = new FunctionExpression(function.image, arguments);
                }

                return functionExpression;
}

  final private List<FunctionExpression.Argument> ArgumentList() throws ParseException {Token comma;
        FunctionExpression.Argument argument;
        List<FunctionExpression.Argument> arguments = new ArrayList<FunctionExpression.Argument>();
    argument = Argument();
arguments.add(argument);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_5;
      }
      comma = jj_consume_token(COMMA);
argument.setEnd(comma);
      argument = Argument();
argument.setBegin(comma); arguments.add(argument);
    }
return arguments;
}

  final private FunctionExpression.Argument Argument() throws ParseException {Token tag = null;
        Expression expression;
    if (jj_2_6(2147483647)) {
      tag = jj_consume_token(IDENTIFIER);
      jj_consume_token(ASSIGN);
      expression = Expression();
    } else if (jj_2_7(2147483647)) {
      tag = jj_consume_token(STRING);
      jj_consume_token(ASSIGN);
      expression = Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case LPAREN:
      case NOT:
      case IF:
      case FALSE:
      case INF:
      case NAN:
      case TRUE:
      case INT:
      case FLOAT:
      case IDENTIFIER:
      case STRING:{
        expression = Expression();
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
FunctionExpression.Argument argument = (tag != null ? new FunctionExpression.Argument(translateTag(tag), expression) : new FunctionExpression.Argument(expression));

                return argument;
}

  final public FieldRef FieldInvocationExpression() throws ParseException {Token name;
    name = jj_consume_token(IDENTIFIER);
FieldRef fieldRef = new FieldRef()
                        .setField(name.image);

                return fieldRef;
}

  final public Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
}

  final public Constant Constant() throws ParseException {Token value;
        DataType dataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case INF:
    case NAN:
    case FLOAT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FLOAT:{
        value = jj_consume_token(FLOAT);
        break;
        }
      case INF:{
        value = jj_consume_token(INF);
        break;
        }
      case NAN:{
        value = jj_consume_token(NAN);
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dataType = DataType.DOUBLE;
      break;
      }
    case FALSE:
    case TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FALSE:{
        value = jj_consume_token(FALSE);
        break;
        }
      case TRUE:{
        value = jj_consume_token(TRUE);
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dataType = DataType.BOOLEAN;
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(translateValue(value))
                        .setDataType(dataType);

                return constant;
}

  final private Interval translateIntervalInternal() throws ParseException {Interval interval;
    interval = Interval();
    jj_consume_token(0);
return interval;
}

  final public Interval Interval() throws ParseException {Token leftBound;
        Double leftMargin;
        Token rightBound;
        Double rightMargin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      leftBound = jj_consume_token(LPAREN);
      break;
      }
    case LBRACKET:{
      leftBound = jj_consume_token(LBRACKET);
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    leftMargin = SignedNumber();
    jj_consume_token(COMMA);
    rightMargin = SignedNumber();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RPAREN:{
      rightBound = jj_consume_token(RPAREN);
      break;
      }
    case RBRACKET:{
      rightBound = jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Interval interval = new Interval(translateClosure(leftBound.image, rightBound.image))
                        .setLeftMargin(filterMargin(leftMargin))
                        .setRightMargin(filterMargin(rightMargin));

                return interval;
}

  final private Double SignedNumber() throws ParseException {Token sign = null;
        Token value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        sign = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        sign = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INT:{
      value = jj_consume_token(INT);
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
      break;
      }
    case INF:{
      value = jj_consume_token(INF);
      break;
      }
    case NAN:{
      value = jj_consume_token(NAN);
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String javaValue = translateValue(value);

                if(sign != null && sign.kind == MINUS){
                        javaValue = ("-" + javaValue);
                }

                return Double.valueOf(javaValue);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(STRING)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionTranslatorTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[27];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x10418,0x8000,0x4000,0x10000,0x7e0000,0x7e0000,0x18,0x18,0xe0,0xe0,0x18,0x18,0x300,0x300,0x400,0x6000000,0x0,0x1000000,0x80010418,0x0,0x0,0x0,0x1400,0x2800,0x18,0x18,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x3e830,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e830,0x0,0x10000,0x0,0x3e830,0x8820,0x2010,0x2e830,0x0,0x0,0x0,0x0,0xc820,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionTranslatorTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[54];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 27; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 54; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 7; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
