/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.ubjson;

import com.devsmart.ubjson.UBArray;
import com.devsmart.ubjson.UBFloat32Array;
import com.devsmart.ubjson.UBFloat64Array;
import com.devsmart.ubjson.UBInt16Array;
import com.devsmart.ubjson.UBInt32Array;
import com.devsmart.ubjson.UBInt64Array;
import com.devsmart.ubjson.UBInt8Array;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBString;
import com.devsmart.ubjson.UBStringArray;
import com.devsmart.ubjson.UBValue;
import com.devsmart.ubjson.UBValueFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class UBWriter
implements Closeable {
    private final OutputStream mOutputStream;

    public UBWriter(OutputStream out) {
        this.mOutputStream = out;
    }

    @Override
    public void close() throws IOException {
        this.mOutputStream.close();
    }

    public void writeNull() throws IOException {
        this.mOutputStream.write(90);
    }

    public void writeBool(boolean value) throws IOException {
        if (value) {
            this.mOutputStream.write(84);
        } else {
            this.mOutputStream.write(70);
        }
    }

    public void writeChar(char value) throws IOException {
        this.mOutputStream.write(67);
        this.mOutputStream.write(value);
    }

    public void writeInt8(byte value) throws IOException {
        this.mOutputStream.write(105);
        this.writeRawInt8(value);
    }

    private void writeRawInt8(byte value) throws IOException {
        this.mOutputStream.write(value);
    }

    public void writeUInt8(short value) throws IOException {
        this.mOutputStream.write(85);
        this.writeRawUInt8(value);
    }

    private void writeRawUInt8(short value) throws IOException {
        this.mOutputStream.write(0xFF & value);
    }

    public void writeInt16(short value) throws IOException {
        this.mOutputStream.write(73);
        this.writeRawInt16(value);
    }

    private void writeRawInt16(short value) throws IOException {
        this.mOutputStream.write(value >> 8);
        this.mOutputStream.write(value);
    }

    public void writeInt32(int value) throws IOException {
        this.mOutputStream.write(108);
        this.writeRawInt32(value);
    }

    private void writeRawInt32(int value) throws IOException {
        this.mOutputStream.write(value >> 24);
        this.mOutputStream.write(value >> 16);
        this.mOutputStream.write(value >> 8);
        this.mOutputStream.write(value);
    }

    public void writeInt64(long value) throws IOException {
        this.mOutputStream.write(76);
        this.writeRawInt64(value);
    }

    private void writeRawInt64(long value) throws IOException {
        this.mOutputStream.write((byte)(0xFFL & value >> 56));
        this.mOutputStream.write((byte)(0xFFL & value >> 48));
        this.mOutputStream.write((byte)(0xFFL & value >> 40));
        this.mOutputStream.write((byte)(0xFFL & value >> 32));
        this.mOutputStream.write((byte)(0xFFL & value >> 24));
        this.mOutputStream.write((byte)(0xFFL & value >> 16));
        this.mOutputStream.write((byte)(0xFFL & value >> 8));
        this.mOutputStream.write((byte)(0xFFL & value));
    }

    public void writeInt(long value) throws IOException {
        if (UBValueFactory.inRange(value, 0L, 255L)) {
            this.writeUInt8((byte)value);
        } else if (UBValueFactory.inRange(value, -128L, 127L)) {
            this.writeInt8((byte)value);
        } else if (UBValueFactory.inRange(value, -32768L, 32767L)) {
            this.writeInt16((short)value);
        } else if (UBValueFactory.inRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            this.writeInt32((int)value);
        } else {
            this.writeInt64(value);
        }
    }

    public void writeFloat32(float value) throws IOException {
        this.mOutputStream.write(100);
        this.writeRawFloat32(value);
    }

    private void writeRawFloat32(float value) throws IOException {
        int intValue = Float.floatToIntBits(value);
        this.writeRawInt32(intValue);
    }

    public void writeFloat64(double value) throws IOException {
        this.mOutputStream.write(68);
        this.writeRawFloat64(value);
    }

    private void writeRawFloat64(double value) throws IOException {
        long intValue = Double.doubleToLongBits(value);
        this.writeRawInt64(intValue);
    }

    public void writeInt8Array(byte[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(105);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawInt8(value[i]);
        }
    }

    public void writeInt16Array(short[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(73);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawInt16(value[i]);
        }
    }

    public void writeInt32Array(int[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(108);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawInt32(value[i]);
        }
    }

    public void writeInt64Array(long[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(76);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawInt64(value[i]);
        }
    }

    public void writeFloat32Array(float[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(100);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawFloat32(value[i]);
        }
    }

    public void writeFloat64Array(double[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(68);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeRawFloat64(value[i]);
        }
    }

    public void writeStringArray(String[] value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(36);
        this.mOutputStream.write(83);
        this.mOutputStream.write(35);
        this.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            String str = value[i];
            if (str == null) {
                throw new IOException("cannot serialize null string in strongly-typed array");
            }
            this.writeData(str.getBytes(UBString.UTF_8));
        }
    }

    public void writeGenericeArray(UBArray value) throws IOException {
        this.mOutputStream.write(91);
        this.mOutputStream.write(35);
        int size = value.size();
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.write(value.get(i));
        }
    }

    private void writeRawString(byte[] data) throws IOException {
        this.writeData(data);
    }

    public void writeString(UBString string) throws IOException {
        this.mOutputStream.write(83);
        byte[] data = string.getData();
        this.writeData(data);
    }

    public void writeData(byte[] data) throws IOException {
        this.writeInt(data.length);
        this.mOutputStream.write(data);
    }

    public void writeData(long len, InputStream in) throws IOException {
        int bytesRead;
        this.writeInt(len);
        byte[] buf = new byte[4096];
        for (long bytesLeft = len; bytesLeft > 0L; bytesLeft -= (long)bytesRead) {
            bytesRead = in.read(buf, 0, (int)Math.min((long)buf.length, bytesLeft));
            if (bytesRead < 0) {
                throw new IOException("input stream too short");
            }
            this.mOutputStream.write(buf, 0, bytesRead);
        }
    }

    public void writeArray(UBArray value) throws IOException {
        switch (value.getStrongType()) {
            case Int8: {
                this.writeInt8Array(((UBInt8Array)value).getValues());
                break;
            }
            case Int16: {
                this.writeInt16Array(((UBInt16Array)value).getValues());
                break;
            }
            case Int32: {
                this.writeInt32Array(((UBInt32Array)value).getValues());
                break;
            }
            case Int64: {
                this.writeInt64Array(((UBInt64Array)value).getValues());
                break;
            }
            case Float32: {
                this.writeFloat32Array(((UBFloat32Array)value).getValues());
                break;
            }
            case Float64: {
                this.writeFloat64Array(((UBFloat64Array)value).getValues());
                break;
            }
            case String: {
                this.writeStringArray(((UBStringArray)value).getValues());
                break;
            }
            default: {
                this.writeGenericeArray(value);
            }
        }
    }

    public void writeObject(UBObject object) throws IOException {
        this.mOutputStream.write(123);
        for (Map.Entry<String, UBValue> entry : object.entrySet()) {
            this.writeData(entry.getKey().getBytes(UBString.UTF_8));
            this.write(entry.getValue());
        }
        this.mOutputStream.write(125);
    }

    public void write(UBValue value) throws IOException {
        switch (value.getType()) {
            case Null: {
                this.writeNull();
                break;
            }
            case Bool: {
                this.writeBool(value.asBool());
                break;
            }
            case Char: {
                this.writeChar(value.asChar());
                break;
            }
            case Int8: {
                this.writeInt8((byte)value.asInt());
                break;
            }
            case Uint8: {
                this.writeUInt8((short)value.asInt());
                break;
            }
            case Int16: {
                this.writeInt16((short)value.asInt());
                break;
            }
            case Int32: {
                this.writeInt32(value.asInt());
                break;
            }
            case Int64: {
                this.writeInt64(value.asLong());
                break;
            }
            case Float32: {
                this.writeFloat32(value.asFloat32());
                break;
            }
            case Float64: {
                this.writeFloat64(value.asFloat64());
                break;
            }
            case String: {
                this.writeString((UBString)value);
                break;
            }
            case Array: {
                this.writeArray(value.asArray());
                break;
            }
            case Object: {
                this.writeObject(value.asObject());
            }
        }
    }
}

