/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Parameter", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Parameter")
@JsonPropertyOrder(value={"name", "label", "referencePoint", "extensions"})
public class Parameter
extends PMMLObject
implements HasExtensions<Parameter>,
Indexable<String> {
    @XmlAttribute(name="name", required=true)
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="label")
    @JsonProperty(value="label")
    private String label;
    @XmlAttribute(name="referencePoint")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="referencePoint")
    private Number referencePoint;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final Number DEFAULT_REFERENCE_POINT = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371266L;

    public Parameter() {
    }

    @ValueConstructor
    public Parameter(@Property(value="name") String name) {
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Parameter setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Parameter setLabel(@Property(value="label") String label) {
        this.label = label;
        return this;
    }

    public Number getReferencePoint() {
        if (this.referencePoint == null) {
            return DEFAULT_REFERENCE_POINT;
        }
        return this.referencePoint;
    }

    public Parameter setReferencePoint(@Property(value="referencePoint") Number referencePoint) {
        this.referencePoint = referencePoint;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Parameter addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

