\name{rthb}
\alias{rthb}


\title{~ Function: R to HTML, Bivariate analysis ~}

\description{
  \code{rthb} performs some bivariate analyses, then generates code to be
  included in a HTML document in order to print out the analyses on a Web page.
}


\usage{
  rthb(formula,fileOut="",textBefore="",textAfter="",graphDir="graphBiv",graphName="V",type="png",displayStyle=7,limDiscreteY=10,limDiscreteX=10)
}

\arguments{
  \item{formula}{\code{[variable~variable]} or \code{[variable~data.frame]} : contains the
    data to analyse. In all the following, the left part will be called
    \code{Y}, the right part will be \code{X}.}

  \item{fileOut}{\code{[character]}
    name of the output file in which
    the HTML summary will be saved. If empty, the HTML code is printed on screen.}

  \item{textBefore}{\code{[character] or [vector(character)]} : before
    printing a variable analysis, \code{rthb} can write a
    text. If \code{X} is a single variable,
    \code{textBefore} should be of length 1. If \code{X} is a \code{data.frame},
    \code{textBefore} can have same length as the number of columns of the \code{data.frame} (this lets
    the user write a specific introduction for each variable), or can be
    of length 1. In this case, it is recycled. See examples for details.}

  \item{textAfter}{\code{[character]} or \code{[vector(character)]} : same
    as \code{textBefore} but the text is printed after the variable
    analysis. See \code{textBefore} and examples for details.}

  \item{graphDir}{\code{[character]} :
    directory used to save the graphs generated by the analyses.}

  \item{graphName}{\code{[character]} or \code{[vector(character)]} :
    prefix for the graph names. If empty, the graph names are
    \code{V1} to \code{V length(data.frame)}}

  \item{type}{\code{[character]} : type of plotting device used to export the
    graphics. Can be Windows metafile, PNG, JPEG, BMP (Windows bitmap format), TIFF,
    PostScript or PDF.}

  \item{displayStyle}{\code{[numeric]} or \code{[vector(numeric)]} :
    when \code{X} is a factor, an ordered factor or a numeric discrete
    variable (see \code{limDiscreteY} for details on discrete
    variables), \code{rthb} proposes two different ways of displaying the results. The
    first one is compact, it displays all the results on two lines. If the
    number of modalities of \code{X} is too big, this
    method could draw tables that outfit the page. In this case, a second display (on
    three lines, less compact but higher) is used.

	The switch (compact/expanded) is done automatically by \code{rthb}
	according to the number of modalities of \code{X}: when it is lower
	than \code{displayStyle}, the compact style is used. When it is greater
	or egal, the expanded style is used.

    If \code{X} is a data.frame, \code{displayStyle} can have the same
    length as \code{X}, or can be of length 1 (and be recycled).}

  \item{limDiscreteY}{\code{[numeric]} : \code{rthb} distinguishes two kinds of \code{numeric} :
    \code{discrete} designates \code{numeric} variables with only a few
    modalities,  \code{continuous} designates \code{numeric} variables with many
    modalities. For the variable \code{Y}, the limit between 'few' and 'many' can be fixed by the
    user through the \code{limDiscreteY} argument. By setting
    \code{limDiscreteY} to 5, the user will ask \code{rthb} to consider
    all the \code{numeric} variables with more than 5 modalities as
    \code{continuous} and all the variables with 5 modalities or less
    as \code{discrete}.

    The default value for \code{limDiscreteY} is 10.}

  \item{limDiscreteX}{\code{[numeric]} or \code{[vector(numeric)]}: same
    as \code{limDiscreteY}. If \code{X} is a \code{data.frame}, \code{limDiscreteX} can have the same
    length as \code{X} or can be of length 1 (and is recycled).}
}

\details{
  \code{rthb} performs some basic analyses, then generates
  code to be included in a HTML document in order to print out the analyses in a 
  Web page.

  \code{rthb} performs the analyses automatically according to the
  \code{data} class. It considers 5 classes: nominal with 2 modalities,
  nominal with 3 modalities or more, ordered, discrete and
  continuous (see the description of \code{limDiscreteY} for details on
  discrete and continuous).

  The analysis of the variable depends on the class of \code{Y} and
  \code{X} wich gives 25 possible combinations. We will not describe all
  of them here.

  They can be divided in two categories. First (on the top of the
  tabular) are descriptive analyses:
  \enumerate{
    \item table: absolute and relative frequency.
    \item summary: mainly when\code{Y} is continuous and \code{X} has
    few modalities.
    \item graphical representation: barplot or boxplot for each
    modalities of \code{X}, mosaic plot, scatter plot, density lines
    according to the type of the variable.
  }

  On the second part of the tabular are all the informations related to
  a potential link between \code{Y} and \code{X}.
  \enumerate{
    \item test: khi2, Fisher exact test, Student's T, ANOVA, Wilcoxon, Kruskal & Wallis,
    Spearman correlation, Pearson correlation, Odds Ratio and Relative
    Risk, depending on the classes of \code{Y} and \code{X}. Note that as
    many tests as possible are run. For example, if \code{Y} is nominal
    and \code{X}is ordered, \code{X} can be considered as
    a factor (khi2 and Fisher exact test) but also as a discrete variable (Wilcoxon).
    \item graphical diagnostic: the test presented might not be all valid. Some
    graphical diagnostic (check for normality) are presented to let the user
    decide which test is more relevant.
  }

The wide display gives :
\preformatted{
+---+---+---+
| 1 | 2 | 3 |
+---+-+-+---+
|  4  |  5  |
+-----+-----+
}

The long display :
\preformatted{
+-------+
|   1   |
+---+---+
| 2 | 3 |
+---+---+
| 4 | 5 |
+---+---+
}

  If \code{X} is a \code{data.frame}, \code{rthb} runs the analyses on every column.
}

\value{
  \code{rthb} generates HTML code and either prints it on the screen, or saves it in a
  file. It also generates several graphs, optionally
  in a different directory.
}

\section{Classical usage}{
  The use of \code{rthb} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the data (usually, a \code{data.frame}).\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Run \code{rthb(Y~dataFrame,"fileOut.html")}.\cr
  }
  See examples of application.
}


\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris\cr
  \cr
  Bernard Desgraupes \cr
  \email{bernard.desgraupes@u-paris10.fr}\cr
  University of Paris Ouest - Nanterre
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris 10 / Nanterre
}


\references{HTML web site \url{http://www.latex-project.org/}\cr
Data are available on line: \url{http://christophe.genolini.free.fr/EPO/EPO2007-Fraude.php}}



\seealso{
  \code{\link{rthMainFile}},
  \code{\link{rthu}},
  \code{\link{r2lUniv-package}},
  \code{\link{examCheating}}
}

\examples{
### Create some data
V1 <- factor(LETTERS[floor(runif(50,1,4))])
V2 <- rnorm(50,1,1)<0
V3 <- ordered(LETTERS[floor(runif(50,1,4))])

### Create a directory for the output
r2lhOutDir <- paste(tempdir(),"rthbExample",sep="/")
if(!file.exists(r2lhOutDir)){dir.create(r2lhOutDir)}
setwd(r2lhOutDir)

### Execute rthb
rthb(V1~V2,fileOut="first.html",textBefore="<H2>Variables V1, V2, V3</H2>",graphName="Gr1",type="png")
rthb(V2~V1,fileOut="second.html",graphName="Gr2",type="png")
rthb(V3~V1,fileOut="third.html",textBefore="This is V3 vs. V1",graphDir="P",graphName="Gr3",type="png",displayStyle=2)
rthMainFile(text="
<LU>
<LI><A HREF='first.html'>First example</A></LI>
<LI><A HREF='second.html'>Second example</A></LI>
<LI><A HREF='third.html'>Third example</A></LI>
</LU>
")
setwd("..")

}

\keyword{print}        % Printing
\keyword{classes}      % Data type
\keyword{programming}  % Programming
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{univar}       % Simple univariate statistics




