% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcd_demo.R
\docType{data}
\name{abcd_demo}
\alias{abcd_demo}
\title{An asset-based company dataset for demonstration}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1470 rows and 14 columns.
}
\usage{
abcd_demo
}
\description{
Fake data about physical assets (e.g. wind turbine power plant
capacities), aggregated to company-level. These data are used to assess the
climate alignment of financial portfolios. It imitates data from
market-intelligence databases.

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://www.transitionmonitor.com/}).
}
\section{Definitions}{

\itemize{
\item \code{abcd_timestamp} (character): Date at which asset data was sourced from the data provider., * \code{company_id} (character): The id of the company owning the asset created by the data provider., * \code{country_of_domicile} (character): Country where company is registered., * \code{emission_factor} (double): Company level emission factor of the technology., * \code{emission_factor_unit} (character): The units that the emission factor is measured in., * \code{is_ultimate_owner} (logical): Flag if company is the ultimate parent in our database., * \code{lei} (character): The legal entity identifier of the company owning the asset., * \code{name_company} (character): The name of the company owning the asset., * \code{plant_location} (character): Country where asset is located., * \code{production} (double): Company level production of the technology., * \code{production_unit} (character): The units that production is measured in., * \code{sector} (character): Sector to which the asset belongs., * \code{technology} (character): Technology implemented by the asset., * \code{year} (integer): Year at which the production value is predicted.
}
}

\examples{
head(abcd_demo)
}
\seealso{
\link{data_dictionary}

Other demo datasets: 
\code{\link{co2_intensity_scenario_demo}},
\code{\link{loanbook_demo}},
\code{\link{overwrite_demo}},
\code{\link{region_isos_demo}},
\code{\link{scenario_demo_2020}}
}
\concept{demo datasets}
\keyword{datasets}
