% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_distance_complex.R
\name{frame_distance_complex}
\alias{frame_distance_complex}
\title{Residual-robust distance plot of quantile regression model}
\usage{
frame_distance_complex(x, resid, tau)
}
\arguments{
\item{x}{matrix, covariate of quantile regression model}

\item{resid}{matrix, residuals of quantile regression models}

\item{tau}{singular or vectors, quantile}
}
\value{
dataframe for residual-robust distance plot
}
\description{
the standardized residuals from quantile regression
against the robust MCD distance. This display is used to diagnose
both vertical outlier and horizontal leverage points. Function
\code{frame_distance} only work for linear quantile regression model. With
non-linear model, use \code{frame_distance_complex}
}
\details{
The generalized MCD algorithm based on the fast-MCD
algorithm formulated by Rousseeuw and Van Driessen(1999), which
is similar to the algorithm for least trimmed squares(LTS).
The canonical Mahalanobis distance is defined as
\deqn{MD(x_i)=[(x_i-\bar{x})^{T}\bar{C}(X)^{-1}(x_i-\bar{x})]^{1/2}}
where \eqn{\bar{x}=\frac{1}{n}\sum_{i=1}^{n}x_i} and
\eqn{\bar{C}(X)=\frac{1}{n-1}\sum_{i=1}^{n}(x_i-\bar{x})^{T}(x_i-
\bar{x})} are the empirical multivariate location and scatter,
respectively. Here \eqn{x_i=(x_{i1},...,x_{ip})^{T}} exclueds the
intercept. The relation between the Mahalanobis distance
\eqn{MD(x_i)} and the hat matrix
\eqn{H=(h_{ij})=X(X^{T}X)^{-1}X^{T}} is
\deqn{h_{ii}=\frac{1}{n-1}MD^{2}_{i}+\frac{1}{n}}
The canonical robust distance is defined as
\deqn{RD(x_{i})=[(x_{i}-T(X))^{T}C(X)^{-1}(x_{i}-T(X))]^{1/2}}
where \eqn{T(X)} and \eqn{C(X)} are the robust multivariate
location and scatter, respectively, obtained by MCD.
To achieve robustness, the MCD algorithm estimates the covariance
of a multivariate data set mainly through as MCD \eqn{h}-point
subset of data set. This subset has the smallest sample-covariance
determinant among all the possible \eqn{h}-subsets. Accordingly,
the breakdown value for the MCD algorithm equals
\eqn{\frac{(n-h)}{n}}. This means the MCD estimates is reliable,
even if up to \eqn{\frac{100(n-h)}{n}}% observations in the data
set are contaminated.
}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
