% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/weibull_fun.R
\name{weibull_fun}
\alias{weibull_fun}
\title{Weibull function}
\usage{
weibull_fun(x, p)
}
\arguments{
\item{x}{Vector of values of the explanatory variable.}

\item{p}{Vector of parameters \eqn{p = c(\alpha, \beta)}.}
}
\value{
Probability at each \code{x}.
}
\description{
Weibull function of the form \eqn{ (1 - exp(-(x/\alpha)^\beta)}
}
\examples{
xseq <- seq(0, 4, .01)
yseq <- weibull_fun(xseq, c(2, 4))
curve <- data.frame(x = xseq, y = yseq)
ggplot(curve, aes(x = x, y = y)) + geom_line()
}

