% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch.R
\name{switch_rows}
\alias{switch_rows}
\title{Switch the index of two rows in a data set}
\usage{
switch_rows(data, row1, row2, keep.cols = NULL)
}
\arguments{
\item{data}{dataset object}

\item{row1}{numeric. the first row number}

\item{row2}{numeric. the second row number}

\item{keep.cols}{numeric or character. column number or name to keep}
}
\description{
Allows the user to choose precisely which two rows they want to swap places,
while optionally preventing some columns from being altered in the process.
Excluded columns within the rows act as anchors that are immune from the switching operation
on the selected rows.
}
\examples{

# Example using mtcars
data100 <- mtcars[1:7,]

head(data100) # preview overall data

# task 1: basic result of switching rows 5 and 6
head(switch_rows(data100, 5, 6))

# task 2: switch rows, but retain some columns
data100[5:6,2:10] # preview the portion that is to be changed

# lets switch 2 rows, but keep content of columns 7, 8, 9 10 within the changed rows
res1 <- switch_rows(data100, row1 = 5, row2 = 6, keep.cols = 7:10) # use column numbers
res1[5:6,] # check result, pay attention to columns 9 and 10 as well
res2 <- switch_rows(data100,
row1 = 5,
row2 = 6,
keep.cols = c("disp","cyl")) # use column names
res2[5:6,] # check result, pay attention to columns "disp","cyl" as well

}
