% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0.7_combo_func1.R
\name{strsplit.num}
\alias{strsplit.num}
\title{Split a string of numbers and return as numeric vector}
\usage{
strsplit.num(x, split, fixed = FALSE, perl = FALSE, useBytes = FALSE)
}
\arguments{
\item{x}{character vector, each element of which is to be split. Other inputs, including a factor, will give an error.}

\item{split}{character vector}

\item{fixed}{logical. If TRUE match split exactly, otherwise use regular expressions. Has priority over perl.}

\item{perl}{logical. Should Perl-compatible regexps be used?}

\item{useBytes}{logical. If TRUE the matching is done byte-by-byte rather than character-by-character, and inputs with marked encodings are not converted.}
}
\value{
numeric values based on split string
}
\description{
The purpose of this function is combine the functionality of
\strong{strsplit}, \strong{unlist} and \strong{as.numeric}, which are often used together.\cr\cr
}
\details{
Given a sting, split by a separator into numbers
}
\examples{
# Example 1
# string of numbers with separator " "
num.01 = "5 3 2 3 5 2 33 23 5 32 432 42 23 554"

# split a string of numbers and return as numeric
strsplit.num(num.01, split = " ")


# Example 2
# string of numbers with separator "|||"
num.02 = "0|||1|||4|||43|||6|||8|||00||| 1||| 0 1||| T |||F|||TRUE |||f"

# split a string of numbers and return as numeric
strsplit.num(num.02, split = "[|||]")

}
