% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-colours.R
\name{divergentColors}
\alias{divergentColors}
\alias{divergentColours}
\alias{divergentColors,character,character,numeric,numeric-method}
\title{Divergent colour palette}
\usage{
divergentColors(
  start.color,
  end.color,
  min.value,
  max.value,
  mid.value = 0,
  mid.color = "white"
)

\S4method{divergentColors}{character,character,numeric,numeric}(
  start.color,
  end.color,
  min.value,
  max.value,
  mid.value = 0,
  mid.color = "white"
)
}
\arguments{
\item{start.color}{Start colour to be passed to \code{colorRampPalette}.}

\item{end.color}{End colour to be passed to \code{colorRampPalette}.}

\item{min.value}{Numeric minimum value corresponding to \code{start.colour}.
If attempting to change the colour of a \code{RasterLayer},
this can be set to \code{minValue(RasterObject)}.}

\item{max.value}{Numeric maximum value corresponding to \code{end.colour}.
If attempting to change the colour of a \code{RasterLayer},
this can be set to \code{maxValue(RasterObject)}.}

\item{mid.value}{Numeric middle value corresponding to \code{mid.colour}.
Default is \code{0}.}

\item{mid.color}{Middle colour to be passed to \code{colorRampPalette}.
Defaults to \code{"white"}.}
}
\value{
A diverging colour palette.
}
\description{
Creates a palette for the current session for a divergent-colour graphic with
a non-symmetric range.
Based on ideas from Maureen Kennedy, Nick Povak, and Alina Cansler.
}
\examples{
divergentColors("darkred", "darkblue", -10, 10, 0, "white")

}
\seealso{
\code{\link[=colorRampPalette]{colorRampPalette()}}
}
\author{
Eliot McIntire and Alex Chubaty
}
