% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{ave_dfm}
\alias{ave_dfm}
\title{Repeated Group Statistics for a Data-Frame}
\usage{
ave_dfm(data, vrb.nm, grp.nm, fun, ...)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames in \code{data} specifying the
variables to use for the aggregation function \code{fun}.}

\item{grp.nm}{character vector of colnames in \code{data} specifying the
grouping variables.}

\item{fun}{function that returns an atomic vector of length 1. Probably makes
sense to ensure the function always returns the same typeof as well.}

\item{...}{additional named arguments to \code{fun}.}
}
\value{
atomic vector of length = \code{nrow(data)} providing the result of
  the function \code{fun} for the subset of data with that group value (i.e.,
  \code{data[levels(interaction(data[grp.nm]))[i], vrb.nm]}) for that row.
}
\description{
\code{ave_dfm} evaluates a function on a set of variables \code{vrb.nm}
separately for each group within \code{grp.nm}. The results are combined back
together in line with the rows of \code{data} similar to \code{\link{ave}}.
\code{ave_dfm} is different than \code{ave} or \code{agg} because it operates
on a data.frame, not an atomic vector.
}
\examples{

# one grouping variables
ave_dfm(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   fun = function(dat) cor(dat, use = "complete")[1,2])

# two grouping variables
ave_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   fun = nrow) # with multiple group columns

}
\seealso{
\code{\link[stats]{ave}} for the same functionality with atomic vector inputs
   \code{\link{agg_dfm}} for similar functionality with data.frames, but can return
      the result for each group once rather than repeating the result for each group
      value in the data.frame
}
