% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_query.R
\name{parse_query}
\alias{parse_query}
\title{Parse a SQL query}
\usage{
parse_query(query, tidyverse = FALSE, secure = TRUE)
}
\arguments{
\item{query}{a character string containing a SQL \code{SELECT} statement}

\item{tidyverse}{set to \code{TRUE} to use functions from tidyverse packages
including dplyr, stringr, and lubridate in the R expressions}

\item{secure}{set to \code{FALSE} to allow potentially dangerous functions in
the returned R expressions}
}
\value{
A list object with named elements representing the clauses of the
  query and containing lists of unevaluated R expressions translated from the
  SQL expressions in the query
}
\description{
Parses a SQL \code{SELECT} statement into a list of R
  expressions
}
\details{
The query must not contain line comments (\code{--}) or block
  comments (\code{/* */}).
}
\examples{
query <- "SELECT origin, dest,
    COUNT(flight) AS num_flts,
    round(AVG(distance)) AS dist,
    round(AVG(arr_delay)) AS avg_delay
  FROM flights
  WHERE distance BETWEEN 200 AND 300
    AND air_time IS NOT NULL
  GROUP BY origin, dest
  HAVING num_flts > 5000
  ORDER BY num_flts DESC, avg_delay DESC
  LIMIT 100;"

parse_query(query)
}
