% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{quarto_publish_doc}
\alias{quarto_publish_doc}
\alias{quarto_publish_app}
\alias{quarto_publish_site}
\title{Publish Quarto Documents}
\usage{
quarto_publish_doc(
  input,
  name = NULL,
  title = NULL,
  server = NULL,
  account = NULL,
  render = c("local", "server", "none"),
  metadata = list(),
  ...
)

quarto_publish_app(
  input = getwd(),
  name = NULL,
  title = NULL,
  server = NULL,
  account = NULL,
  render = c("local", "server", "none"),
  metadata = list(),
  ...
)

quarto_publish_site(
  input = getwd(),
  name = NULL,
  title = NULL,
  server = NULL,
  account = NULL,
  render = c("local", "server", "none"),
  metadata = list(),
  ...
)
}
\arguments{
\item{input}{The input file or project directory to be published. Defaults to
the current working directory.}

\item{name}{Name for publishing (names must be unique within an account).
Defaults to the name of the \code{input}.}

\item{title}{Free-form descriptive title of application. Optional; if
supplied, will often be displayed in favor of the name. When deploying a new
document, you may supply only the title to receive an auto-generated name}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[rsconnect:accounts]{accounts()}} to see the full list of available options.}

\item{render}{\code{local} to render locally before publishing; \code{server} to
render on the server; \code{none} to use whatever rendered content currently
exists locally. (defaults to \code{local})}

\item{metadata}{Additional metadata fields to save with the deployment
record. These fields will be returned on subsequent calls to
\code{\link[rsconnect:deployments]{deployments()}}.}

\item{...}{Named parameters to pass along to \code{rsconnect::deployApp()}}
}
\description{
Publish Quarto documents to Posit Connect, ShinyApps, and RPubs
}
\examples{
\dontrun{
library(quarto)
quarto_publish_doc("mydoc.qmd")
quarto_publish_app(server = "shinyapps.io")
quarto_publish_site(server = "rstudioconnect.example.com")
}

}
