% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagKernelWeight.R
\docType{class}
\name{LagKernelWeight-class}
\alias{LagKernelWeight-class}
\alias{LagKernelWeight}
\title{Class for lag window generators}
\description{
\code{LagKernelWeight} is an S4 class that implements a weighting function by
specification of a kernel function \code{W} and a scale parameter \code{bw}.
}
\details{
It extends the class \code{\link{Weight}} and writes
\deqn{W_N(x[k]) := W(x[k]/bw)}
to \code{values[k]} [nested inside \code{env}] for \code{k=1,\ldots,length(x)}.
The points \code{x} where \eqn{W} is evaluated may be set on construction or updated when
evoking the method \code{getValues}.
}
\section{Slots}{

\describe{
\item{\code{W}}{a kernel function}

\item{\code{bw}}{bandwidth}

\item{\code{env}}{An environment to allow for slots which need to be
accessable in a call-by-reference manner:
\describe{
  \item{\code{values}}{A vector storing the weights; see the Details
        section.}
}}
}}

\seealso{
Examples for implementations of kernels \code{W} can be found at:
\code{\link{kernels}}.
}
\keyword{S4-classes}
