% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/Class-QuantilePG.R
\name{QuantilePG-constructor}
\alias{QuantilePG-constructor}
\alias{quantilePG}
\title{Create an instance of the \code{\link{QuantilePG}} class.}
\usage{
quantilePG(Y, frequencies = 2 * pi/length(Y) * 0:(length(Y) - 1),
  levels.1 = 0.5, levels.2 = levels.1, isRankBased = TRUE,
  type = c("clipped", "qr"), type.boot = c("none", "mbb"), B = 0, l = 0,
  method = c("br", "fn", "pfn", "fnc", "lasso", "scad"), parallel = FALSE)
}
\arguments{
\item{Y}{A \code{vector} of real numbers containing the time series from
which to determine the quantile periodogram or a \code{ts} object
or a \code{zoo} object.}

\item{frequencies}{A vector containing frequencies at which to determine the
quantile periodogram.}

\item{levels.1}{A vector of length \code{K1} containing the levels \code{x1}
at which the QuantilePG is to be determined.}

\item{levels.2}{A vector of length \code{K2} containing the levels \code{x2}.}

\item{isRankBased}{If true the time series is first transformed to pseudo
data [cf. \code{\link{FreqRep}}].}

\item{type}{A flag to choose the type of the estimator. Can be either
\code{"clipped"} or \code{"qr"}. In the first case
\code{\link{ClippedFT}} is used as a frequency representation, in
the second case \code{\link{QRegEstimator}} is used.}

\item{type.boot}{A flag to choose a method for the block bootstrap; currently
two options are implemented: \code{"none"} and \code{"mbb"}
which means to do a moving blocks  bootstrap with \code{B}
and \code{l} as specified.}

\item{B}{number of bootstrap replications}

\item{l}{(expected) length of blocks}

\item{method}{method used for computing the quantile regression estimates.
The choice is passed to \code{qr}; see the
documentation of \code{quantreg} for details.}

\item{parallel}{a flag to allow performing parallel computations,
                  where possible.}
}
\value{
Returns an instance of \code{QuantilePG}.
}
\description{
The parameter \code{type.boot} can be set to choose a block bootstrapping
procedure. If \code{"none"} is chosen, a moving blocks bootstrap with
\code{l=length(Y)} and  \code{N=length(Y)} would be done. Note that in that
case one would also chose \code{B=0} which means that \code{getPositions}
would never be called. If \code{B>0} then each bootstrap replication would
be the undisturbed time series.
}
\keyword{Constructors}

