\docType{methods}
\name{plot-KernelWeight}
\alias{plot,KernelWeight,missing-method}
\alias{plot-KernelWeight}
\title{Plot the values of the \code{\link{KernelWeight}}.}
\usage{
\S4method{plot}{KernelWeight,missing}(x, y, ylab = expression(W[n](omega)),
  xlab = expression(omega), main = x@descr, ...)
}
\arguments{
  \item{x}{The \code{\link{KernelWeight}} to plot.}

  \item{y}{missing arg from the generic; will be ignored.}

  \item{xlab}{label for the x-axis; optional}

  \item{ylab}{label for the y-axis; optional}

  \item{main}{titel (on top) of the plot; optional}

  \item{...}{optional parameters used for plotting}
}
\value{
Plots the \code{\link{KernelWeight}}.
}
\description{
Creates a plot visualizing the weights \eqn{W_n(\omega)}
[cf. \code{\link{KernelWeight-class}}] that are used to
estimate the quantile spectral density.
}
\details{
In the plot the values at the frequencies \eqn{2\pi j / N},
\eqn{j=L+1-N,\ldots,L}, \eqn{L:=\lfloor N/2 \rfloor} are
shown, where \eqn{N} is the parameter specified on
construction of the object or \eqn{N := 3}, if that
parameter was smaller than three. A warning is given in the
later case.
}
\examples{
plot(kernelWeight(W1, bw=0.3),
       ylab=expression(W[n](x)),
       xlab=expression(x),
       main="Weights to an Epanechnikov kernel", sub="bw=0.3")
}

