% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic2.R
\name{kwic}
\alias{kwic}
\alias{is.kwic}
\alias{as.kwic}
\title{locate keywords-in-context}
\usage{
kwic(x, keywords, window = 5, valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, ..., new = TRUE)

is.kwic(x)

as.kwic(x)
}
\arguments{
\item{x}{a character, \link{corpus}, or \link{tokens} object}

\item{keywords}{a keyword pattern or phrase consisting of multiple keyword 
patterns, possibly including punctuation.  If a phrase, \code{keywords} 
will be tokenized using the \code{...} options.}

\item{window}{the number of context words to be displayed around the keyword.}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{match without respect to case if \code{TRUE}}

\item{...}{additional arguments passed to \link{tokens}, for applicable 
object types}

\item{new}{logical; if \code{TRUE} use the newer \code{kwic}, if \code{FALSE}
then call \code{\link{kwic_old}}.  Once the full
testing of the newer \link{kwic} method is complete and the transition
declared successful, we will delete this option and delete \code{kwic_old}.}
}
\value{
A kwic object classed data.frame, with the document name 
  (\code{docname}), the token index position (\code{position}), the context
  before (\code{contextPre}), the keyword in its original format
  (\code{keyword}, preserving case and attached punctuation), and the context
  after (\code{contextPost}).
}
\description{
For a text or a collection of texts (in a quanteda corpus object), return a 
list of a keyword supplied by the user in its immediate context, identifying 
the source text and the word index number within the source text.  (Not the 
line number, since the text may or may not be segmented using end-of-line 
delimiters.)
}
\details{
\code{as.kwic} is a temporary function to convert a "kwic2" to a standard 
"kwic" object.
}
\examples{
head(kwic(data_char_inaugural, "secure*", window = 3, valuetype = "glob"))
head(kwic(data_char_inaugural, "secur", window = 3, valuetype = "regex"))
head(kwic(data_char_inaugural, "security", window = 3, valuetype = "fixed"))

kwic(data_corpus_inaugural, "war against")
kwic(data_corpus_inaugural, "war against", valuetype = "regex")

mykwic <- kwic(data_corpus_inaugural, "provident*")
is.kwic(mykwic)
is.kwic("Not a kwic")
# as.kwic examples
txt <- c("This is a test",
         "This is it.",
         "What is in a train?",
         "Is it a question?",
         "Sometimes you don't know if this is it.",
         "Is it a bird or a plane or is it a train?")

toks <- tokens(txt)
(kwOld <- kwic(toks, "is it", new = FALSE))
(kwNew <- kwic(toks, "is it", new = TRUE))
\dontrun{
# this breaks - need to harmonize print methods
as.kwic(kwNew)
}
}
\author{
Kenneth Benoit and Kohei Watanabe
}
