% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_wordscores.R
\name{predict.textmodel_wordscores}
\alias{predict.textmodel_wordscores}
\title{Predict textmodel_wordscores}
\usage{
\method{predict}{textmodel_wordscores}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  interval = c("none", "confidence"),
  level = 0.95,
  rescaling = c("none", "lbg", "mv"),
  force = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted Wordscores textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{se.fit}{if \code{TRUE}, return standard errors as well}

\item{interval}{type of confidence interval calculation}

\item{level}{tolerance/confidence level for intervals}

\item{rescaling}{\code{"none"} for "raw" scores; \code{"lbg"} for LBG (2003)
rescaling; or \code{"mv"} for the rescaling proposed by Martin and Vanberg
(2007).  See References.}

\item{force}{make the feature set of \code{newdata} conform to the model
terms.  The default of \code{TRUE} means that a fitted model can be applied
to scale a dfm that does not contain a 1:1 match of features in the
training and prediction data.}

\item{...}{not used}
}
\value{
\code{predict.textmodel_wordscores()} returns a named vector of predicted
document scores ("text scores" \eqn{S_{vd}} in LBG 2003), or a named list if
\code{se.fit = TRUE} consisting of the predicted scores (\verb{$fit}) and the
associated standard errors (\verb{$se.fit}). When \code{interval = "confidence"}, the predicted values will be a matrix.  This behaviour matches
that of \code{\link[stats:predict.lm]{stats::predict.lm()}}.
}
\description{
Predict textmodel_wordscores
}
\examples{
tmod <- textmodel_wordscores(data_dfm_lbgexample, c(seq(-1.5, 1.5, .75), NA))
predict(tmod)
predict(tmod, rescaling = "mv")
predict(tmod, rescaling = "lbg")
predict(tmod, se.fit = TRUE)
predict(tmod, se.fit = TRUE, interval = "confidence")
predict(tmod, se.fit = TRUE, interval = "confidence", rescaling = "lbg")
}
\keyword{internal}
\keyword{textmodel}
