% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iheatmap.R
\name{iheatmap}
\alias{iheatmap}
\title{Interactive heat map}
\usage{
iheatmap(z, x = NULL, y = NULL, chartOpts = NULL, digits = 5)
}
\arguments{
\item{z}{Numeric matrix of dim \code{length(x)} x \code{length(y)}}

\item{x}{Vector of numeric values for the x-axis}

\item{y}{Vector of numeric values for the y-axis}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive heatmap, with each cell linked to
plots of horizontal and vertical slices
}
\details{
By default, the z-axis limits are from \code{-max(abs(z))}
to \code{max(abs(z))}, and negative cells are colored blue to white
which positive cells are colored white to red.
}
\examples{
n <- 101
x <- y <- seq(-2, 2, len=n)
z <- matrix(ncol=n, nrow=n)
for(i in seq(along=x))
    for(j in seq(along=y))
        z[i,j] <- x[i]*y[j]*exp(-x[i]^2 - y[j]^2)
\donttest{
iheatmap(z, x, y)}

}
\seealso{
\code{\link{iplotCorr}}
}
\keyword{hplot}

