% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_xo.R
\name{count_xo}
\alias{count_xo}
\title{Count numbers of crossovers}
\usage{
count_xo(geno, quiet = TRUE, cores = 1)
}
\arguments{
\item{geno}{List of matrices of genotypes (output of \code{\link[=maxmarg]{maxmarg()}} or \code{\link[=viterbi]{viterbi()}})
or a list of 3d-arrays of genotypes (output of \code{\link[=sim_geno]{sim_geno()}}).}

\item{quiet}{If FALSE, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A matrix of crossover counts, individuals x chromosomes, or
(if the input was the output of \code{\link[=sim_geno]{sim_geno()}}) a
3d-array of crossover counts, individuals x chromosomes x
imputations.
}
\description{
Estimate the numbers of crossovers in each individual on each chromosome.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[1:20,1:2] # subset to first 20 individuals and to chr 1 and 2}
map <- insert_pseudomarkers(iron$gmap, step=1)
pr <- calc_genoprob(iron, map, error_prob=0.002, map_function="c-f")
g <- maxmarg(pr)
n_xo <- count_xo(g)

# imputations
imp <- sim_geno(iron, map, error_prob=0.002, map_function="c-f", n_draws=32)
n_xo_imp <- count_xo(imp)
# sums across chromosomes
tot_xo_imp <- apply(n_xo_imp, c(1,3), sum)
# mean and SD across imputations
summary_xo <- cbind(mean=rowMeans(tot_xo_imp),
                    sd=apply(tot_xo_imp, 1, sd))

}
\seealso{
\code{\link[=locate_xo]{locate_xo()}}
}
