% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qs_serialize}
\alias{qs_serialize}
\title{qs_serialize}
\usage{
qs_serialize(object,
         compress_level = qopt("compress_level"),
         shuffle = qopt("shuffle"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{object}{The object to save.}

\item{compress_level}{The compression level used (the initial value is 3L).

The maximum and minimum possible values depend on the version of the ZSTD library used.
As of ZSTD 1.5.6 the maximum compression level is 22, and the minimum is -131072.
Usually, values in the low positive range offer very good performance in terms
of speed and compression.}

\item{shuffle}{Whether to allow byte shuffling when compressing data (the initial value is TRUE).}

\item{nthreads}{The number of threads to use when compressing data (the initial value is 1L).}
}
\value{
The serialized object as a raw vector.
}
\description{
Serializes an object to a raw vector using the \code{qs2} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
xserialized <- qs_serialize(x)
x2 <- qs_deserialize(xserialized)
identical(x, x2) # returns TRUE
}
