% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_deserialize}
\alias{qd_deserialize}
\title{qd_deserialize}
\usage{
qd_deserialize(input,
         use_alt_rep = qopt("use_alt_rep"),
         validate_checksum = qopt("validate_checksum"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{input}{The raw vector to deserialize.}

\item{use_alt_rep}{Use ALTREP when reading in string data (the initial value is FALSE).}

\item{validate_checksum}{Whether to validate the stored checksum in the file (the initial value is FALSE).}

\item{nthreads}{The number of threads to use when reading data (the initial value is 1L).}
}
\value{
The deserialized object.
}
\description{
Deserializes a raw vector to an object using the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
xserialized <- qd_serialize(x)
x2 <- qd_deserialize(xserialized)
identical(x, x2) # returns TRUE
}
