% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qs_read}
\alias{qs_read}
\title{qs_read}
\usage{
qs_read(file, validate_checksum=FALSE, nthreads = 1L)
}
\arguments{
\item{file}{The file name/path.}

\item{validate_checksum}{Whether to validate the stored checksum in the file (default \code{FALSE}). This can be used to test for file corruption but has a performance penality.}

\item{nthreads}{The number of threads to use when reading data (default: \code{1}).}
}
\value{
The object stored in \code{file}.
}
\description{
Reads an object that was saved to disk in the \code{qs2} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(state.name, 1e3, replace=TRUE),
        stringsAsFactors = FALSE)
myfile <- tempfile()
qs_save(x, myfile)
x2 <- qs_read(myfile)
identical(x, x2) # returns true
}
