% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpower.R
\name{fpower}
\alias{fpower}
\title{Folded Power Transformation}
\usage{
fpower(p, lambda, eps)
}
\arguments{
\item{p}{Mortality proportion}

\item{lambda}{Power \code{lambda} for the power transformation}

\item{eps}{If \code{eps>0} \code{phat} is replaced by
\eqn{\frac{p+\epsilon}{1+\epsilon}} before applying
the power transformation.}
}
\value{
The transformed values of \code{fpower(p)}.
}
\description{
The name \dQuote{folded Power Transformation} is used because
this does for power transformations what Tukey's folded logarithm
does for the logarithmic tranformation.  The function calculates
\deqn{f(p, \lambda, \epsilon) = \frac{p+\epsilon}{1-p+\epsilon}^\lambda}
where \eqn{\lambda} is the power and \eqn{\epsilon} is a positive
offset that ensures that \eqn{\frac{p+\epsilon}{1-p+\epsilon}} is
greater than 0 and finite.
}
\examples{
p <- (0:10)/10
ytrans <- fpower(p, lambda=0.25, eps=1/450)
}
