# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Equivalent to rank(x, ties.method="max"), but considerably faster
#'
#' @param x Numeric Vector
#' @return A vector of same length of x of elements 1:length(x)
#' @export
qmdrank <- function(x) {
    .Call(`_qmd_qmdrank`, x)
}

#' Calculates the empirical checkerboard approximation to some data.
#' 
#' @param X A nxrho matrix of n samples of rho variables
#' @param resolution The resolution of the CB approximation
#' @return A matrix of dimension resolution^rho
#' @export
.ECBC <- function(X, resolution) {
    .Call(`_qmd_ECBC`, X, resolution)
}

#' Calculates an empirical CB approximation with adaptive bin sizes. This will be faster on data with many ties.
#' 
#' @param X A nxrho matrix of n samples of rho variables
#' @param resolution The resolution of the CB approximation
#' @return A matrix of dimension resolution^rho
#' @export
.EACBC <- function(X, resolution) {
    .Call(`_qmd_EACBC`, X, resolution)
}

#' Returns the sizes of the adaptive bins used for the adaptive ECBC for one vector.
#' 
#' @param X A vector, representing one sample of one variable
#' @param resolution The resolution of the CB approximation
#' @return A numeric vector of bin sizes
#' @export
.adaptive_masses <- function(X, resolution) {
    .Call(`_qmd_adaptive_masses`, X, resolution)
}

#' Returns a list of reverse cumulative margins of a CB copula. The nth entry is thus the copula of X1,...,Xn
#' 
#' @param CB A matrix of CB weights.
#' @return A list of CB weight matrixes of ascending dimension
#' @export
.CB_make_cumulative_df <- function(CB) {
    .Call(`_qmd_CB_make_cumulative_df`, CB)
}

#' Creates a random CB copula of resolution 2^steps
#' 
#' @param rho The number of variables
#' @param steps Number of iteration steps, the final resolution will be 2^steps
#' @param de Exponent to increase dependence
#' @param ie Exponent to increase independence
#' @return A matrix of dimension (2^steps)^rho
#' @export
.random_CB <- function(rho, steps, de, ie) {
    .Call(`_qmd_random_CB`, rho, steps, de, ie)
}

#' Generate a sample of some CB copula-
#' 
#' @param CB A weight matrix of a CB copula
#' @param n The number of samples to be generated
#' @return Matrix of dimension nxm where m is the dimension of CB
#' @export
.sample_CB <- function(CB, n) {
    .Call(`_qmd_sample_CB`, CB, n)
}

#' Computes the D1-difference of two CB matrizes on a local CB dimension
#' 
#' @param k1 Vector of local CB weights of first matrix
#' @param k2 Vector of local CB weights of second matrix
#' @param y Vector indicating the bin sizes of the local dimension
#' @return number indicating the difference between k1 and k2
#' @export
.local_kernel_integral <- function(k1, k2, y) {
    .Call(`_qmd_local_kernel_integral`, k1, k2, y)
}

#' Returns non 0 entries of the EACBC
#' 
#' @param X A nxrho matrix of n samples of rho variables
#' @param resolution The resolution of the CB approximation
#' @return A list of local kernel masses
#' @export
.EACBC_nonzero <- function(X, resolution) {
    .Call(`_qmd_EACBC_nonzero`, X, resolution)
}

