% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgg_utility_functions.R
\name{predict_auc_mt_cc}
\alias{predict_auc_mt_cc}
\title{Expected AUC for prediction of a binary trait using information on correlated binary trait}
\usage{
predict_auc_mt_cc(h2x, Nx, Kx, Px, h2y, Ny, Ky, Py, rg, Me, M)
}
\arguments{
\item{h2x}{Heritability of the target trait.}

\item{Nx}{Number of samples for the target trait.}

\item{Kx}{Prevalence of the target trait.}

\item{Px}{Case-control proportion of the target trait.}

\item{h2y}{Heritability of the correlated trait.}

\item{Ny}{Number of samples for the correlated trait.}

\item{Ky}{Prevalence of the correlated trait.}

\item{Py}{Case-control proportion of the correlated trait.}

\item{rg}{Genetic correlation between the target and the correlated trait.}

\item{Me}{Number of independent chromosome segments.}

\item{M}{Number of markers.}
}
\value{
A numeric value representing the expected AUC.
}
\description{
Computes the expected Area Under the Curve (AUC) for predicting a binary trait using 
information on a correlated binary trait.
}
\keyword{internal}
