% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_diet_grid.R
\name{make_diet_grid}
\alias{make_diet_grid}
\title{Generate a regular grid of diet compositions}
\usage{
make_diet_grid(uniq_types, inv_inc)
}
\arguments{
\item{uniq_types}{A factor of unique prey-type names.}

\item{inv_inc}{The integer inverse of the resolution between consecutive
diet compositions.}
}
\value{
A list containing the following elements: \describe{
  \item{diet_grid}{A numeric matrix of grid diet compositions, in
    column-major format.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{make_diet_grid} generates a systematic grid of
regularly-spaced diet compositions with a user-specified resolution.
}
\section{Details}{

The function \code{make_diet_grid} generates a systematic grid of
regularly-spaced diet compositions throughout the space of all possible
diets for a given number of prey types. Such a diet composition grid may be
useful in some simulation studies of estimator performance (e.g., Bromaghin
et al. 2016). Given a diet composition, predator fatty acid signatures can be
generated using the function \code{\link{make_pred_sigs}}. The diets of such
simulated predators can then be estimated, and the resulting estimates can be
compared to the known diet composition to evaluate bias, variance, and
perhaps other properties.

The algorithm starts with a diet proportion of 1.0 assigned to the first prey
type, and therefore 0.0 for the other prey types. The algorithm then begins
an iterative loop in which an increment of diet proportion is repeatedly
shifted to the other prey types, stopping when the last prey type has a diet
proportion of 1.0. The user controls the resolution of the grid by specifying
the integer inverse of the desired diet increment.  For example, an inverse
increment of 10 would produce diet compositions with proportions shifted by
an increment of 0.1. See Bromaghin et al. (2016) for a small example with
three prey types and a diet increment of 0.25.  However, note that unlike
Bromaghin et al. (2016), \code{make_diet_grid} retains diet compositions
comprised of a single prey type.

It is critical that the prey-type names match those in the prey library. The
easiest way to ensure this happens is to pass the object uniq_types returned
a call to the function \code{\link{prep_sig}} as the uniq_types argument.
Alternatively, and more risky, a vector of unique prey names can be created
using the concatenate function and cast as a factor, i.e.,
uniq_types <- as.factor(c("Prey_1", "Prey_2", ..., "Prey_P)).

NOTE: The number of possible diets grows quickly as the number of prey types
increases and the diet increment decreases, and may exceed memory limits.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty acid
signature proportions sum to 1 for diet estimation? Ecological Research
31:597-606.
}
\examples{
make_diet_grid(uniq_types = as.factor(c("Bearded",
                                        "Beluga",
                                        "Bowhead",
                                        "Ribbon",
                                        "Ringed",
                                        "Spotted",
                                        "Walrus")),
               inv_inc = 10)

}

