% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopo.R
\name{lopo}
\alias{lopo}
\title{Leave-one-prey-out analysis}
\usage{
lopo(sigs, type, uniq_types, type_ss, loc, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sigs}{A numeric matrix of fatty acid signatures in column-major
format.}

\item{type}{A character vector of prey or predator type names.}

\item{uniq_types}{A character vector of the unique types, sorted
alphanumerically.}

\item{type_ss}{The number of signatures (sample size) for each unique
\code{type}.}

\item{loc}{A numeric matrix specifying the location of signatures within
\code{sigs} for each \code{uniq_types}.}

\item{dist_meas}{A integer indicator of the distance measure to use. Default
value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
A list containing the following elements: \describe{
  \item{est}{A square matrix containing the mean distribution of estimates
    among all prey types, by prey-type.}
  \item{mean_correct}{The mean proportion correctly estimated across prey
    types, unweighted by prey-type sample sizes.}
  \item{total_correct}{The proportion of all signatures correctly estimated.}
  \item{n_conv}{An integer vector containing the number of estimates that
    converged.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string containing a brief summary of the results.}
}
}
\description{
The function \code{lopo} evaluates the distinctiveness of a prey library by
performing a leave-one-prey-out analysis.
}
\section{Details}{

The object passed as the argument \code{sigs} is intended to be the signature
object returned by \code{\link{sig_scale}} or, if the prey library has been
partitioned, by \code{\link{make_prey_part}}.

The objects passed as the arguments \code{type}, \code{uniq_types},
\code{type_ss}, and \code{loc} are intended to be the corresponding objects
returned by \code{\link{prep_sig}} or, if the prey library has been
partitioned, by \code{\link{make_prey_part}}.

The arguments \code{dist_meas} and \code{gamma} must be compatible with the
function \code{\link{dist_between_2_sigs}}.

\code{lopo} performs a leave-one-prey-out analysis with a prey library and
defined prey types (Bromaghin et al. 2016b).  Each signature is
temporarily removed from the library, the mean prey-type signature is
recomputed, and the "diet" of the removed signature is estimated, after which
the removed signature is returned to the library.  This is done for each
signature in turn.  The mean estimate for each prey type is returned as a
row of \code{est}.  Perfect estimation would result in the square matrix
\code{est} having 1.0 along its diagonal and 0.0 in all off-diagonal
positions.  Large off-diagonal elements are indicative of confounding, or
similarity, between the corresponding prey types.  The returned object
\code{mean_correct} is the mean of the diagonal elements of \code{est},
while the returned object \code{total_correct} is the mean computed over all
signatures in the prey library.

Note: the statistics are computed based on the estimates that successfully
converge (\code{n_conv}) and prey types that only have a sample size of 1 are
skipped.

Because of the numerical optimization involved in a leave-one-prey-out
analysis, \code{lopo} can take a few minutes to run with a large prey
library.

The statistics computed by \code{lopo} are one measure of the distinctiveness
of prey types within a prey library.  However, it is important to be aware
that such statistics are not necessarily informative of the ability of QFASA
to accurately estimate predator diets, as Bromaghin et al. (2015, 2016a,
2016b) found that QFASA performance depends strongly on the interaction
between characteristics of a prey library, the specific diet of a predator,
and the accuracy of the calibration coefficients.  Consequently, the user is
warned not to misinterpret or misrepresent these statistics.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016b. Should fatty
  acid signature proportions sum to 1 for diet estimation?
  \emph{Ecological Research} 31:597-606.

Bromaghin, J.F., S.M. Budge, G.W. Thiemann, and K.D. Rode. 2016b. Assessing
  the robustness of quantitative fatty acid signature analysis to assumption
  violations. \emph{Methods in Ecology and Evolution} 7:51-59.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.
}
\examples{
lopo(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                     0.04, 0.11, 0.29, 0.56,
                     0.10, 0.05, 0.35, 0.50,
                     0.12, 0.03, 0.37, 0.48,
                     0.10, 0.06, 0.35, 0.49,
                     0.05, 0.15, 0.35, 0.45), ncol=6),
     type = c("Type_1", "Type_1", "Type_2", "Type_2", "Type_3", "Type_3"),
     uniq_types = c("Type_1", "Type_2", "Type_3"),
     type_ss <- c(2, 2, 2),
     loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
     dist_meas = 1)

lopo(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                     0.04, 0.11, 0.29, 0.56,
                     0.10, 0.05, 0.35, 0.50,
                     0.12, 0.03, 0.37, 0.48,
                     0.10, 0.06, 0.35, 0.49,
                     0.05, 0.15, 0.35, 0.45), ncol=6),
     type = c("Type_1", "Type_1", "Type_2", "Type_2", "Type_3", "Type_3"),
     uniq_types = c("Type_1", "Type_2", "Type_3"),
     type_ss <- c(2, 2, 2),
     loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
     dist_meas = 2)

lopo(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                     0.04, 0.11, 0.29, 0.56,
                     0.10, 0.05, 0.35, 0.50,
                     0.12, 0.03, 0.37, 0.48,
                     0.10, 0.06, 0.35, 0.49,
                     0.05, 0.15, 0.35, 0.45), ncol=6),
     type = c("Type_1", "Type_1", "Type_2", "Type_2", "Type_3", "Type_3"),
     uniq_types = c("Type_1", "Type_2", "Type_3"),
     type_ss <- c(2, 2, 2),
     loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
     dist_meas = 3,
     gamma = 0.25)

lopo(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                     0.04, 0.11, 0.29, 0.56,
                     0.10, 0.05, 0.35, 0.50,
                     0.12, 0.03, 0.37, 0.48,
                     0.10, 0.06, 0.35, 0.49,
                     0.05, 0.15, 0.35, 0.45), ncol=6),
     type = c("Type_1", "Type_1", "Type_2", "Type_2", "Type_3", "Type_3"),
     uniq_types = c("Type_1", "Type_2", "Type_3"),
     type_ss <- c(2, 2, 2),
     loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
     dist_meas = 3)

lopo(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                     0.04, 0.11, 0.29, 0.56,
                     0.10, 0.05, 0.35, 0.50,
                     0.12, 0.03, 0.37, 0.48,
                     0.10, 0.06, 0.35, 0.49,
                     0.05, 0.15, 0.35, 0.45), ncol=6),
     type = c("Type_1", "Type_1", "Type_2", "Type_2", "Type_3", "Type_3"),
     uniq_types = c("Type_1", "Type_2", "Type_3"),
     type_ss <- c(2, 2, 2),
     loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2))

}

