% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdqcs.rank.r
\name{fdqcs.rank}
\alias{fdqcs.rank}
\alias{fdqcs.rank.fdqcd}
\title{Function to plot rank functional data (DFD) - chart}
\usage{
fdqcs.rank(x, ...)

\method{fdqcs.rank}{fdqcd}(
  x,
  y = x,
  func.depth = depth.FM,
  alpha = 0.01,
  plot = TRUE,
  trim = 0.1,
  draw.control = NULL,
  ...
)
}
\arguments{
\item{x}{an R object (used to select the method). See details.}

\item{...}{arguments passed to or from methods.}

\item{y}{The set of new curves to evaluate the depth. fdqcd class object.
The set of reference curves respect to which the depth is computed. fdqcd class object.}

\item{func.depth}{Type of depth measure, by default depth.mode.}

\item{alpha}{Quantile to determine the cutoff from the Bootstrap procedure}

\item{plot}{a logical value indicating that it should be plotted.}

\item{trim}{The porcentage of the trimming.}

\item{draw.control}{ist that it specifies the col, lty and lwd for objects: fdataobj, statistic, IN and OUT.}
}
\description{
This function is used to compute statistics required by the RFD chart.
}
\examples{
\dontrun{
library(qcr)
m <- 30
tt<-seq(0,1,len=m)
mu<-30 * tt * (1 - tt)^(3/2)
n0 <- 100
set.seed(12345)
mdata<-matrix(NA,ncol=m,nrow=n0)
sigma <- exp(-3*as.matrix(dist(tt))/0.9)
for (i in 1:n0) mdata[i,]<- mu+0.5*mvrnorm(mu = mu,Sigma = sigma )
fdchart <- fdqcd(mdata)
summary(fdchart)
plot(fdchart,type="l",col="gray")
out <- fddep$out
## Outliers - State in Control
alpha <- 0.005
trim <- 0.1
while (length(out)>0) {
 mdata <- fddep$fdata$data[-out,]
 fddep <- fdqcs.depth(mdata,ns = alpha, trim=trim, plot=FALSE)
 out <- fddep$out
}
plot(fddep,title.fdata = "FD-State in Control",title.depth = "Depth")
# Ha
mu_a<- 30 * tt^(3/2) * (1 - tt)
n_a <- 50
set.seed(12345)
mdata_a<-matrix(NA,ncol=m,nrow=n_a)
for (i in 1:n_a) mdata_a[i,]<- mu_a+0.5*mvrnorm(mu = mu_a,Sigma = sigma )
fdchart_a <- fdqcd(mdata_a,"Curves Monitoring")
plot(fdchart_a)
plot(fdchart,fdchart_a,main="Phase II")
pashe2.chart <- fdqcs.rank(fdchart,fdchart_a)
plot(pashe2.chart,title.fdata = "FDA",title.rank = "Rank")
summary(pashe2.chart)
}
}
\references{
Flores, M.; Naya, S.; Fernández-Casal,R.; Zaragoza, S.; Raña, P.; Tarrío-Saavedra, J. 
Constructing a Control Chart Using Functional Data. Mathematics 2020, 8, 58.
}
