qat_analyse_histogram_test_emd_1d <-
function(measurement_vector, blocksize,numofbars) {
## functionality: calculates a field, which compares distributions of blocks of a measurement vector and compare them by Earth Mover's distance
## author: André Düsterhus
## date: 08.12.2010
## version: A0.1
## input: measurement_vector
## output: list with a field, blocksize, numofbars
	# calculating the number of blocks
	runs<-floor(length(measurement_vector)/blocksize)
	# initialisation of the array, which should store the result
	resultarray<- array(0.0,c(runs,runs))
	minimum <- min(measurement_vector, na.rm=TRUE)
	maximum <- max(measurement_vector, na.rm=TRUE)
	# cycles over all block, so that each block get compared with each other
	for (ii in 1:runs) {
		for (jj in 1:runs) {
			# producing two vectors of data of length blocksize, which should be analysed in this step
			data1 <- measurement_vector[((ii-1)*blocksize+1):(ii*blocksize)]
			data2 <- measurement_vector[((jj-1)*blocksize+1):(jj*blocksize)]
			# calculating the individual maximum and minimum of the two vectors and constructing a vector of breaks
			breakvector<- seq(minimum,maximum,length.out=numofbars)
			# calculating histograms of both data-vectors with the given breakvector
			hdata1<-hist(data1, breaks= breakvector,plot=FALSE)
			hdata2<-hist(data2, breaks= breakvector,plot=FALSE)
			# extracting densities
			h1density<-cumsum(hdata1$counts/sum(hdata1$counts))
			h2density<-cumsum(hdata2$counts/sum(hdata2$counts))
			result <- array(0.0,length(numofbars))
			result <- abs(h1density-h2density)
			resultarray[ii,jj] <- 1/numofbars*sum(result)
		}
	}
	resultlist <- list(field=resultarray, blocksize=blocksize,numofbars=numofbars, metric="emd", runs=runs)
	return(resultlist)
}
