% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_strip.R
\name{pystr_strip}
\alias{pystr_strip}
\title{Strip a string.}
\usage{
pystr_strip(str, chars = " ")
}
\arguments{
\item{str}{A character vector.}

\item{chars}{A character string.}
}
\value{
A character vector.
}
\description{
Return a copy of the string with the leading and trailing characters removed.
}
\details{
The \code{chars} argument is a string specifying the set of characters to be
removed. If omitted, the \code{chars} argument defaults to removing whitespace.
The \code{chars} argument is not a prefix or suffix; rather, all combinations
of its values are stripped.
}
\examples{
pystr_strip("   very spacious   ")
pystr_strip("www.example.com", "cmowz.")
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.strip}
}
\seealso{
\code{\link{pystr_lstrip}}, \code{\link{pystr_rstrip}}
}

