% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bayes_weights.R
\name{bayes_weights}
\alias{bayes_weights}
\title{Bayes p-value weights}
\usage{
bayes_weights(mu, sigma, q)
}
\arguments{
\item{mu}{the estimated means, a vector of length J.}

\item{sigma}{the standard errors, a positive vector of length J}

\item{q}{level at which tests will be performed}
}
\value{
A list containing:

 \code{w} - the optimal Bayes weights;

 \code{lambda} - the dual certificate, normalizing constant produced by solving the optimization problem;

 \code{q_star} - true value of q solved for;

 \code{q_threshold} - maximal value of q for which problem can be solve exactly;
}
\description{
Computes the optimal Bayes p-value weights for multiple testing.
Given estimated means \code{mu} and standard errors \code{sigma} of test statistics \code{T},
the weighting scheme optimizes the expected number of discoveries
using \code{T} as test statistics in multiple testing
at some specific level q.
}
\details{
Specifically, it is assumed that \code{T} are Gaussian with mean
\code{eta}. One-sided tests of \code{eta>=0} against \code{eta<0}
 are conducted using the test statistics \code{T}. To optimize power,
 different levels are allocated to different tests. This is based on the
 prior information about \code{eta} in \code{mu,sigma}

For more details, see the paper "Optimal Multiple Testing Under a
 Gaussian Prior on the Effect Sizes", by Dobriban, Fortney, Kim and Owen,
  \url{http://arxiv.org/abs/1504.02935}
}
\examples{
J <- 100
mu <- rnorm(J)
sigma <- 1 * rep(1, J)
q <- 0.05 / J
res <- bayes_weights(mu, sigma, q)
}
\seealso{
Other p.value.weighting: \code{\link{exp_weights}};
  \code{\link{iGWAS}}; \code{\link{spjotvoll_weights}}
}

